/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.validator.AbstractCertValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.EncryptAlgorithms;
import java.util.List;
import org.sourceid.common.XmlEncryption;

public abstract class EncryptionSettingsValidator
extends AbstractCertValidator {
    protected final ConnectionCredentials credentials;
    private Cert encryptionCert;
    private final boolean isFullValidationPath;

    public EncryptionSettingsValidator(ConnectionCredentials credentials, boolean isFullValidationPath) {
        this.credentials = credentials;
        this.isFullValidationPath = isFullValidationPath;
    }

    public boolean validate() {
        ConnectionCert cert = this.getEncryptionCert();
        if (this.isEncryptionRequired()) {
            if (cert == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_cert_not_found, CredentialsPath.getConnectionCerts(this.isFullValidationPath)));
            } else {
                this.checkForMultipleEncryptionCerts(this.credentials.getCerts());
                String credentialFieldPath = CredentialsPath.getConnectionCertX509FileData(this.getEncryptionCertIndex(), this.isFullValidationPath);
                this.encryptionCert = this.validateCert(cert, credentialFieldPath, "Encryption Certificate", false);
            }
            this.validateEncryptionBlock(this.credentials.getBlockEncryptionAlgorithm());
            this.validateKeyTransport(this.credentials.getKeyTransportAlgorithm());
        } else {
            if (cert != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_cert_not_required, CredentialsPath.getConnectionCerts(this.isFullValidationPath), new Object[]{CredentialsPath.getConnectionCerts(this.isFullValidationPath)}));
            }
            if (this.credentials.getBlockEncryptionAlgorithm() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath), new Object[]{CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath)}));
            }
            if (this.credentials.getKeyTransportAlgorithm() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, CredentialsPath.getKeyTransportAlg(this.isFullValidationPath), new Object[]{CredentialsPath.getKeyTransportAlg(this.isFullValidationPath)}));
            }
        }
        return !this.hasErrors();
    }

    private void checkForMultipleEncryptionCerts(List<ConnectionCert> certs) {
        if (certs != null) {
            ConnectionCert foundCert = null;
            for (ConnectionCert cert : certs) {
                if (!cert.isEncryptionCert().booleanValue()) continue;
                if (foundCert != null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_cert_multiple_found, CredentialsPath.getConnectionCerts(!this.isFullValidationPath)));
                }
                foundCert = cert;
            }
        }
    }

    private void validateKeyTransport(String keyTransportAlgorithm) {
        if (this.credentials.getKeyTransportAlgorithm() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_key_transport_algorithm_missing, CredentialsPath.getKeyTransportAlg(this.isFullValidationPath)));
            return;
        }
        if (PropertyInfo.HSM_MODE.LUNA != PropertyInfo.getHSMMode() && EncryptAlgorithms.RSA_V1DOT5.getDisplayName().equals(keyTransportAlgorithm) && !this.isExistingRSA()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_key_transport_algorithm_not_supported, CredentialsPath.getKeyTransportAlg(this.isFullValidationPath)));
            return;
        }
        try {
            EncryptAlgorithms.fromDisplayName((String)keyTransportAlgorithm);
        }
        catch (EncryptAlgorithms.AlgorithmNotFoundException e) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_key_transport_algorithm_invalid, CredentialsPath.getKeyTransportAlg(this.isFullValidationPath)));
        }
    }

    private void validateEncryptionBlock(String blockEncryptionAlgorithm) {
        if (this.credentials.getBlockEncryptionAlgorithm() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_block_encrypt_algorithm_missing, CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath)));
        } else {
            try {
                EncryptAlgorithms.fromDisplayName((String)blockEncryptionAlgorithm);
            }
            catch (EncryptAlgorithms.AlgorithmNotFoundException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_block_encrypt_algorithm_invalid, CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath)));
                return;
            }
            if (EncryptAlgorithms.AES_256.getDisplayName().equals(this.credentials.getBlockEncryptionAlgorithm()) && !XmlEncryption.isEncryptionAlgorithmAvailable((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_block_encrypt_algorithm_not_supported, CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath)));
            }
            if (EncryptAlgorithms.TRIPLE_DES.getDisplayName().equals(this.credentials.getBlockEncryptionAlgorithm()) && PropertyInfo.isBCFIPSMode()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_block_encrypt_algorithm_not_supported_in_bcfips, CredentialsPath.getEncryptionBlockAlg(this.isFullValidationPath)));
            }
        }
    }

    protected Integer getEncryptionCertIndex() {
        if (this.credentials.getCerts() == null) {
            return null;
        }
        int i = 0;
        for (ConnectionCert cert : this.credentials.getCerts()) {
            if (cert.isEncryptionCert().booleanValue()) {
                return i;
            }
            ++i;
        }
        return null;
    }

    protected ConnectionCert getEncryptionCert() {
        Integer certIndex = this.getEncryptionCertIndex();
        return certIndex != null ? this.credentials.getCerts().get(certIndex) : null;
    }

    public Cert getConvertedEncryptionCert() {
        return this.encryptionCert;
    }

    abstract boolean isEncryptionRequired();

    abstract boolean isExistingRSA();
}

