/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExpectedAttributesValidator
extends AbstractValidator {
    private final String attribute;
    private final List<String> expectedAttributes;
    private final ApiMessageKey errorMessageKey;
    private final String fieldPath;
    private final String friendlyFieldName;

    public ExpectedAttributesValidator(String attribute, List<String> expectedAttributes, ApiMessageKey errorMessageKey, String fieldPath, String friendlyFieldName) {
        this.attribute = attribute;
        this.expectedAttributes = expectedAttributes;
        this.errorMessageKey = errorMessageKey;
        this.fieldPath = fieldPath;
        this.friendlyFieldName = friendlyFieldName;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.attribute)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, this.fieldPath, new Object[]{this.friendlyFieldName}));
        }
        boolean isValid = this.expectedAttributes.contains(this.attribute);
        if (!StringUtils.isBlank((String)this.attribute) && !isValid) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.errorMessageKey, this.fieldPath, new Object[]{this.attribute}));
        }
        return isValid;
    }
}

