/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;

public class ExtendedMetadataSourceTypeValidator
extends AbstractValidator {
    private final String targetAttribute;
    private final String targetParam;
    private final String fieldPath;
    private final Set<String> validExtendedMetadataNames;
    private final ExtendedMetadataSourceTypeMsgContext msgContext;
    private final boolean appendPrefix;
    private final SourceType sourceType;

    ExtendedMetadataSourceTypeValidator(String targetAttribute, String targetParam, Set<String> validExtendedMetadataNames, String fieldPath, ExtendedMetadataSourceTypeMsgContext msgContext, SourceType sourceType) {
        this.targetAttribute = targetAttribute;
        this.targetParam = targetParam;
        this.validExtendedMetadataNames = validExtendedMetadataNames;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
        this.appendPrefix = true;
        this.sourceType = sourceType;
    }

    ExtendedMetadataSourceTypeValidator(String targetAttribute, String targetParam, Set<String> validExtendedMetadataNames, String fieldPath, ExtendedMetadataSourceTypeMsgContext msgContext, boolean appendPrefix, SourceType sourceType) {
        this.targetAttribute = targetAttribute;
        this.targetParam = targetParam;
        this.validExtendedMetadataNames = validExtendedMetadataNames;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
        this.appendPrefix = appendPrefix;
        this.sourceType = sourceType;
    }

    public boolean validate() {
        String prefix = "";
        if (this.appendPrefix) {
            prefix = SourceType.EXTENDED_PROPERTIES == this.sourceType ? "extproperties." : "extclientmetadata.";
        }
        String targetParamWithPrefix = prefix + this.targetParam;
        if (this.validExtendedMetadataNames == null || !this.validExtendedMetadataNames.contains(targetParamWithPrefix)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getInvalidExtendedMetadataParamName(), this.fieldPath, new Object[]{this.targetAttribute}));
        }
        return !this.hasErrors();
    }

    public static enum ExtendedMetadataSourceTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getInvalidExtendedMetadataParamName() {
                return ApiMessageKey.mapping_source_type_extended_property_invalid_param;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getInvalidExtendedMetadataParamName() {
                return ApiMessageKey.issuance_criteria_source_type_extended_property_invalid_param;
            }
        };


        public abstract ApiMessageKey getInvalidExtendedMetadataParamName();
    }
}

