/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.FederationInfoPaths;
import com.pingidentity.admin.api.model.systemsettings.FederationInfo;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class FederationInfoValidator
extends AbstractValidator {
    private final String baseUrl;
    private final String saml2EntityId;
    private final String saml1xIssuerId;
    private final String saml1xSourceId;
    private final String wsfedRealm;
    private final String baseFieldPath;
    private static final String SAML2 = "SAML 2.0 Entity ID";
    private static final String SAML1x = "SAML 1.x Issuer/Audience";
    private static final String WSFED = "WS-Federation Realm";

    private FederationInfoValidator(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.saml2EntityId = builder.saml2EntityId;
        this.saml1xIssuerId = builder.saml1xIssuerId;
        this.saml1xSourceId = builder.saml1xSourceId;
        this.wsfedRealm = builder.wsfedRealm;
        this.baseFieldPath = StringUtils.isBlank((String)builder.baseFieldPath) ? "" : builder.baseFieldPath + ".";
    }

    private String getFieldPath(String relativePath) {
        return this.baseFieldPath + relativePath;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.baseUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_base_url_required, this.getFieldPath(FederationInfoPaths.getBaseUrl())));
        } else if (!ValidationUtil.isValidHttpOrHttpsUrl((String)this.baseUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, this.getFieldPath(FederationInfoPaths.getBaseUrl()), new Object[]{this.baseUrl}));
        } else if (ValidationUtil.endsWithForwardSlash((String)this.baseUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_base_url_ending_slash, ConnectionPaths.getBaseUrl()));
        }
        if (StringUtils.isNotBlank((String)this.saml2EntityId) && !CommonValidator.isValidEntityId((String)this.saml2EntityId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_connection_id_invalid, this.getFieldPath(FederationInfoPaths.getSaml2EntityId()), new Object[]{SAML2}));
        } else if (StringUtils.isBlank((String)this.saml2EntityId)) {
            this.validateSaml20EntityIdNotNeeded();
        }
        if (StringUtils.isNotBlank((String)this.saml1xIssuerId) && !CommonValidator.isValidEntityId((String)this.saml1xIssuerId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_connection_id_invalid, this.getFieldPath(FederationInfoPaths.getSaml1xIssuerId()), new Object[]{SAML1x}));
        } else if (StringUtils.isBlank((String)this.saml1xIssuerId)) {
            this.validateSaml1XIssuerNotNeeded();
        }
        if (StringUtils.isNotBlank((String)this.saml1xSourceId)) {
            if (HexBin.stringToBytes((String)this.saml1xSourceId) == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_format_invalid, this.getFieldPath(FederationInfoPaths.getSaml1xSourceId())));
            }
            if (this.saml1xSourceId.length() != 40) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_length_invalid, this.getFieldPath(FederationInfoPaths.getSaml1xSourceId())));
            }
        }
        if (StringUtils.isNotBlank((String)this.wsfedRealm) && !CommonValidator.isValidEntityId((String)this.wsfedRealm)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_connection_id_invalid, this.getFieldPath(FederationInfoPaths.getWsfedRealm()), new Object[]{WSFED}));
        } else if (StringUtils.isBlank((String)this.wsfedRealm)) {
            this.validateWsFedRealmNotNeeded();
        }
        return !this.hasErrors();
    }

    private void validateSaml20EntityIdNotNeeded() {
        if (this.checkConnectionsUsingProtocol(Protocol.SAML20)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_saml20_entity_id_required, this.getFieldPath(FederationInfoPaths.getSaml2EntityId())));
        } else if (!MgmtFactory.getTokenGeneratorManager().getInstancesForTokenType(WsTrustTokenType.SAML20.getUri()).isEmpty() || !MgmtFactory.getTokenProcessorManager().getInstancesForTokenType(WsTrustTokenType.SAML20.getUri()).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_ws_trust_only, this.getFieldPath(FederationInfoPaths.getSaml1xIssuerId()), new Object[]{SAML2}));
        }
    }

    private void validateSaml1XIssuerNotNeeded() {
        if (this.checkConnectionsUsingProtocol(Protocol.SAML10) || this.checkConnectionsUsingProtocol(Protocol.SAML11)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_saml1x_issuer_required, this.getFieldPath(FederationInfoPaths.getSaml1xIssuerId())));
        } else if (!MgmtFactory.getTokenGeneratorManager().getInstancesForTokenType(WsTrustTokenType.SAML11.getUri()).isEmpty() || !MgmtFactory.getTokenProcessorManager().getInstancesForTokenType(WsTrustTokenType.SAML11.getUri()).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_ws_trust_only, this.getFieldPath(FederationInfoPaths.getSaml1xIssuerId()), new Object[]{SAML1x}));
        }
    }

    private void validateWsFedRealmNotNeeded() {
        if (this.checkConnectionsUsingProtocol(Protocol.WSFED)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.federation_info_wsfed_realm_required, this.getFieldPath(FederationInfoPaths.getWsfedRealm())));
        }
    }

    private boolean checkConnectionsUsingProtocol(Protocol protocol) {
        Collection connections = MgmtFactory.getConnectionManager().getAllConnections();
        for (ConnectionBase connection : connections) {
            if (!protocol.equals((Object)connection.getProtocol())) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private String baseUrl;
        private String saml2EntityId;
        private String saml1xIssuerId;
        private String saml1xSourceId;
        private String wsfedRealm;
        private String baseFieldPath = "";

        public Builder withFederationInfo(FederationInfo fedInfo) {
            this.baseUrl = fedInfo.getBaseUrl();
            this.saml2EntityId = fedInfo.getSaml2EntityId();
            this.saml1xIssuerId = fedInfo.getSaml1xIssuerId();
            this.saml1xSourceId = fedInfo.getSaml1xSourceId();
            this.wsfedRealm = fedInfo.getWsfedRealm();
            return this;
        }

        public Builder setBaseFieldPath(String baseFieldPath) {
            this.baseFieldPath = baseFieldPath;
            return this;
        }

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setSaml2EntityId(String saml2EntityId) {
            this.saml2EntityId = saml2EntityId;
            return this;
        }

        public Builder setSaml1xIssuerId(String saml1xIssuerId) {
            this.saml1xIssuerId = saml1xIssuerId;
            return this;
        }

        public Builder setSaml1xSourceId(String saml1xSourceId) {
            this.saml1xSourceId = saml1xSourceId;
            return this;
        }

        public Builder setWsfedRealm(String wsfedRealm) {
            this.wsfedRealm = wsfedRealm;
            return this;
        }

        public FederationInfoValidator build() {
            return new FederationInfoValidator(this);
        }
    }
}

