/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.FragmentInfo;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class FragmentPolicyOutputContractValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final String fieldPath;
    private final boolean noChildren;
    private final FragmentInfo fragmentInfo;
    private final String apcId;

    public FragmentPolicyOutputContractValidator(String fieldPath, boolean noChildren, FragmentInfo fragmentInfo, String apcId) {
        this.fieldPath = fieldPath;
        this.noChildren = noChildren;
        this.fragmentInfo = fragmentInfo;
        this.apcId = apcId;
    }

    public boolean validate() {
        if (this.fragmentInfo != null && this.noChildren) {
            if (StringUtils.isBlank((String)this.fragmentInfo.getOutputContractId())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_with_end_node_apc_or_lip_not_allowed, this.fieldPath));
            } else if (!this.fragmentInfo.getOutputContractId().equals(this.apcId)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_end_node_apc_or_lip_does_not_matching_fragment_output_policy_contract, this.fieldPath, new Object[]{this.fragmentInfo.getOutputContractId()}));
            }
        }
        return !this.hasErrors();
    }
}

