/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ContactInfo;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.EmailValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.common.XmlWhitespace;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class GeneralInfoValidator
extends CompositeValidator {
    private Role role;
    private String id;
    private String entityId;
    private String connectionName;
    private String defaultVirtualEntityId;
    private List<String> virtualEntityIds;
    private String baseUrl;
    private String applicationIconUrl;
    private ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private Protocol protocol;
    private static final int MAX_LEN_NAME = 512;
    private String idLabel;

    public GeneralInfoValidator() {
    }

    public GeneralInfoValidator(Role role, String id, String entityId, String connectionName, String defaultVirtualEntityId, List<String> virtualEntityIds, String baseUrl, String contactEmail, String applicationIconUrl, Protocol protocol) {
        this.init(role, id, entityId, connectionName, defaultVirtualEntityId, virtualEntityIds, baseUrl, contactEmail, applicationIconUrl, protocol);
    }

    public GeneralInfoValidator(Connection connection) {
        String defaultVirtualEntityId = connection.getDefaultVirtualEntityId();
        List<String> virtualEntityIds = connection.getVirtualEntityIds();
        String contactEmail = null;
        ContactInfo contactInfo = connection.getContactInfo();
        if (contactInfo != null) {
            contactEmail = connection.getContactInfo().getEmail();
        }
        String applicationIconUrl = "";
        if (connection instanceof SpConnection) {
            applicationIconUrl = ((SpConnection)connection).getApplicationIconUrl();
        }
        Protocol protocol = null;
        if (connection.getBrowserSso() != null && connection.getBrowserSso().getProtocol() != null) {
            protocol = Protocol.valueOf((String)connection.getBrowserSso().getProtocol().name());
        }
        this.init(connection.getType().getRole(), connection.getId(), connection.getEntityId(), connection.getName(), defaultVirtualEntityId, virtualEntityIds, connection.getBaseUrl(), contactEmail, applicationIconUrl, protocol);
    }

    private void init(Role role, String id, String entityId, String connectionName, String defaultVirtualEntityId, List<String> virtualEntityIds, String baseUrl, String contactEmail, String applicationIconUrl, Protocol protocol) {
        this.role = role;
        this.id = id;
        this.entityId = entityId;
        this.connectionName = connectionName;
        this.defaultVirtualEntityId = defaultVirtualEntityId;
        this.virtualEntityIds = virtualEntityIds;
        this.baseUrl = baseUrl;
        this.applicationIconUrl = applicationIconUrl;
        this.protocol = protocol;
        this.addValidator((Validator)new EmailValidator(contactEmail, ApiMessageKey.general_info_email_invalid, ConnectionPaths.getContactEmail()));
        this.idLabel = Protocol.OIDC == protocol ? "Issuer" : "Connection ID";
    }

    public void setConnectionManager(ConnectionManager mgr) {
        this.connectionManager = mgr;
    }

    @Override
    public boolean validate() {
        boolean vsidsExists;
        super.validate();
        boolean bl = vsidsExists = this.virtualEntityIds != null && !this.virtualEntityIds.isEmpty();
        if (StringUtils.isBlank((String)this.entityId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_id_required, ConnectionPaths.getConnectionEntityId(), new Object[]{this.idLabel}));
        } else {
            String whitespaceCollapsedEntityId;
            if (Protocol.OIDC == this.protocol) {
                if (!ValidationUtil.isValidHttpsUrl((String)this.entityId)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_issuer_invalid, ConnectionPaths.getConnectionEntityId()));
                }
                if (StringUtils.isNotEmpty((String)this.defaultVirtualEntityId)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_virtual_entity_id_not_supported, ConnectionPaths.getDefaultVirtualEntityId()));
                }
                if (this.virtualEntityIds != null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_virtual_entity_id_not_supported, ConnectionPaths.getVirtualEntityIds()));
                }
            } else if (!CommonValidator.isValidEntityId((String)this.entityId)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_id_invalid, ConnectionPaths.getConnectionEntityId()));
            }
            if ((whitespaceCollapsedEntityId = XmlWhitespace.collapse((String)this.entityId)).length() != this.entityId.length()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_entity_id_with_sequential_spaces, ConnectionPaths.getConnectionEntityId()));
            }
            if (this.entityId.contains("\t")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_entity_id_with_tabs, ConnectionPaths.getConnectionEntityId()));
            }
            if (this.role == Role.IDP && this.connectionManager.isEntityIdInUse(this.entityId, this.id) || this.role == Role.SP && this.connectionManager.isEntityIdInUseForSp(this.entityId, this.id)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_id_in_use, ConnectionPaths.getConnectionEntityId(), new Object[]{this.idLabel}));
            }
        }
        if (StringUtils.isBlank((String)this.connectionName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_name_required, ConnectionPaths.getConnectionName()));
        } else {
            if (this.connectionManager.isNameInUse(this.connectionName, this.id, this.role)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_name_in_use, ConnectionPaths.getConnectionName()));
            }
            if (this.connectionName.length() > 512) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_connection_name_length_invalid, ConnectionPaths.getConnectionName(), new Object[]{512}));
            }
        }
        int index = 0;
        if (vsidsExists) {
            HashSet<String> uniqueIds = new HashSet<String>();
            for (String virtualEntityId : this.virtualEntityIds) {
                if (!StringUtils.isBlank((String)virtualEntityId)) {
                    if (!CommonValidator.isValidEntityId((String)virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_virtual_entity_id_invalid, ConnectionPaths.getVirtualEntityId(index), new Object[]{virtualEntityId}));
                    } else if (!uniqueIds.add(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_entry, "Virtual Server ID", new Object[]{ConnectionPaths.getVirtualEntityId(index), virtualEntityId}));
                    }
                }
                ++index;
            }
        }
        if (StringUtils.isEmpty((String)this.defaultVirtualEntityId)) {
            if (vsidsExists) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_default_virtual_entity_id_required, ConnectionPaths.getDefaultVirtualEntityId()));
            }
        } else if (!vsidsExists || vsidsExists && !this.virtualEntityIds.contains(this.defaultVirtualEntityId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_default_virtual_entity_id_invalid, ConnectionPaths.getDefaultVirtualEntityId()));
        }
        if (!StringUtils.isBlank((String)this.baseUrl)) {
            ApiMessageKey baseUrlMsgKey;
            boolean validBaseUrl;
            if (Protocol.OIDC == this.protocol) {
                validBaseUrl = ValidationUtil.isValidHttpsUrl((String)this.baseUrl);
                baseUrlMsgKey = ApiMessageKey.general_info_base_url_malformed_https;
            } else {
                validBaseUrl = ValidationUtil.isValidHttpOrHttpsUrl((String)this.baseUrl);
                baseUrlMsgKey = ApiMessageKey.general_info_base_url_malformed;
            }
            if (!validBaseUrl) {
                this.appendError(ValidationErrorFactory.getInstance().create(baseUrlMsgKey, ConnectionPaths.getBaseUrl()));
            } else if (ValidationUtil.endsWithForwardSlash((String)this.baseUrl)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.general_info_base_url_ending_slash, ConnectionPaths.getBaseUrl()));
            }
        }
        if (StringUtils.isNotBlank((String)this.applicationIconUrl) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.applicationIconUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, ConnectionPaths.getApplicationIconUrl(), new Object[]{this.applicationIconUrl}));
        }
        return !this.hasErrors();
    }

    void setRole(Role role) {
        this.role = role;
    }

    void setId(String id) {
        this.id = id;
    }

    void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    void setDefaultVirtualEntityId(String defaultVirtualEntityId) {
        this.defaultVirtualEntityId = defaultVirtualEntityId;
    }

    void setVirtualEntityIds(List<String> virtualEntityIds) {
        this.virtualEntityIds = virtualEntityIds;
    }

    void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setApplicationIconUrl(String applicationIconUrl) {
        this.applicationIconUrl = applicationIconUrl;
    }
}

