/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.GlobalAuthenticationSessionPolicy;
import com.pingidentity.admin.api.model.fieldpaths.GlobalAuthenticationSessionPolicyPaths;
import com.pingidentity.admin.api.validator.AuthenticationSessionValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.sourceid.saml20.domain.SessionTimeUnit;

public class GlobalAuthenticationSessionPolicyValidator
extends AuthenticationSessionValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private Boolean enableSessions;

    public GlobalAuthenticationSessionPolicyValidator(Boolean enableSessions, String idleTimeoutMins, SessionTimeUnit idleTimeoutDisplayUnit, String maxTimeoutMins, SessionTimeUnit maxTimeoutDisplayUnit) {
        super(idleTimeoutMins, idleTimeoutDisplayUnit, maxTimeoutMins, maxTimeoutDisplayUnit);
        this.enableSessions = enableSessions;
    }

    public GlobalAuthenticationSessionPolicyValidator(GlobalAuthenticationSessionPolicy policy) {
        super(policy, policy.getIdleTimeoutDisplayUnit(), policy.getMaxTimeoutDisplayUnit());
        this.enableSessions = policy.isEnableSessions();
    }

    @Override
    public String getIdleTimeoutPath() {
        return GlobalAuthenticationSessionPolicyPaths.getIdleTimeoutMins();
    }

    @Override
    public String getMaxTimeoutPath() {
        return GlobalAuthenticationSessionPolicyPaths.getMaxTimeoutMins();
    }

    @Override
    public Integer getDefaultIdleTimeout() {
        return 60;
    }

    @Override
    public Integer getDefaultMaxTimeout() {
        return 480;
    }

    @Override
    public boolean validate() {
        if (this.enableSessions == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_enable_sessions_required, GlobalAuthenticationSessionPolicyPaths.getEnableSessions()));
        }
        super.validate();
        return !this.hasErrors();
    }
}

