/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.GroupMembershipDetection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class GroupMembershipDetectionValidation
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private GroupMembershipDetection groupMembershipDetection;
    private int index;
    private LdapInfo.LdapType ldapType;

    GroupMembershipDetectionValidation(int index, LdapInfo.LdapType ldapType, GroupMembershipDetection groupMembershipDetection) {
        this.groupMembershipDetection = groupMembershipDetection;
        this.index = index;
        this.ldapType = ldapType;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.ldapType == LdapInfo.LdapType.ActiveDirectory) {
            if (StringUtils.isBlank((String)this.groupMembershipDetection.getMemberOfGroupAttributeName())) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_member_of_attr_name_required_AD, ConnectionPaths.OutboundProvisionPaths.getMemberOfGroupAttr(this.index));
                this.appendError(error);
            }
        } else if (StringUtils.isBlank((String)this.groupMembershipDetection.getMemberOfGroupAttributeName()) && StringUtils.isBlank((String)this.groupMembershipDetection.getGroupMemberAttributeName())) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_member_of_group_or_group_member_required, ConnectionPaths.OutboundProvisionPaths.getGroupMembership(this.index));
            this.appendError(error);
        } else if ((this.ldapType == LdapInfo.LdapType.SunDirectoryServer || this.ldapType == LdapInfo.LdapType.OracleUnifiedDirectory) && StringUtils.isNotBlank((String)this.groupMembershipDetection.getMemberOfGroupAttributeName())) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_member_of_group_not_required, ConnectionPaths.OutboundProvisionPaths.getMemberOfGroupAttr(this.index));
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

