/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class HttpUrlValidator
extends AbstractValidator {
    private final boolean isOptional;
    private final String url;
    private final String fieldPath;

    public HttpUrlValidator(String url, boolean isOptional, String fieldPath) {
        this.isOptional = isOptional;
        this.url = url;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        boolean result = true;
        if (!this.isOptional && StringUtils.isBlank((String)this.url)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.url_required, this.fieldPath));
            result = false;
        } else if (!StringUtils.isBlank((String)this.url) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.url)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, this.fieldPath, new Object[]{this.url}));
            result = false;
        }
        return result;
    }
}

