/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import java.util.Set;

public class IdpAdapterAttributeFulfillmentValidator
extends AttributeMappingValidator {
    public IdpAdapterAttributeFulfillmentValidator(AttributeMapping mapping, Set<String> validAttributeNames, Set<String> coreSourceSubstitutionVars, String coreSourceName, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, String baseMappingPath, ValidatorContext context) {
        super(mapping, validAttributeNames, coreSourceSubstitutionVars, coreSourceName, validSources, true, baseMappingPath, context);
    }

    @Override
    protected void validateFulfillment(Map<String, AttributeFulfillmentValue> attrFulfillment, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        super.validateFulfillment(attrFulfillment, validSourceTypes, validSources);
        if (!this.hasErrors()) {
            String fulfillmentPath = ConnectionPaths.getAttributeMappingContractFulfillmentPath(this.attrMappingPath);
            for (String attrName : attrFulfillment.keySet()) {
                AttributeFulfillmentValue attributeFulfillmentValue = attrFulfillment.get(attrName);
                if (attributeFulfillmentValue.getSource().getType() != SourceType.ADAPTER || attributeFulfillmentValue.getValue().compareTo(attrName) == 0) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_invalid_value_for_adapter_source, ConnectionPaths.getAttributeMappingPath(fulfillmentPath, attrName), new Object[]{attrName}));
            }
        }
    }
}

