/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.IdpAdapterPaths;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AdapterValidator;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.UniqueUserKeyAttributeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.profiles.idp.AuthnCtxChecker;

public class IdpAdapterValidator
extends AdapterValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final IdpAdapter apiAdapter;

    public IdpAdapterValidator(IdpAdapter apiInstance, boolean isCreate, ValidatorContext validatorContext) {
        this(apiInstance, isCreate, false, "", validatorContext);
    }

    public IdpAdapterValidator(IdpAdapter apiInstance, boolean isCreate, boolean isOverride, String parentPath, ValidatorContext validatorContext) {
        super(apiInstance, PluginEnum.IDP_ADAPTER.getPluginManager(), isCreate, PluginEnum.IDP_ADAPTER, isOverride, parentPath, validatorContext);
        this.apiAdapter = apiInstance;
    }

    @Override
    public boolean validate() {
        boolean doContractValidation;
        super.validate();
        boolean askedForParent = this.apiAdapter.getParentRef() != null;
        boolean isInherited = this.getBooleanVal(this.apiAdapter.getAttributeContract().isInherited());
        boolean bl = doContractValidation = !isInherited || !askedForParent;
        if (isInherited && !askedForParent) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_attribute_contract_parent_not_defined, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getContractInherited())));
        }
        if (StringUtils.isNotEmpty((String)this.apiAdapter.getAuthnCtxClassRef())) {
            this.validateAuthnCtxClassRef();
        }
        if (doContractValidation) {
            boolean pluginAllowsExtAttrs = true;
            Object coreAttrs = new HashSet();
            LinkedList<IdpAdapterAttribute> attributes = new LinkedList<IdpAdapterAttribute>();
            String pluginTypeId = null;
            if (this.apiAdapter.getPluginDescriptorRef() != null) {
                pluginTypeId = this.apiAdapter.getPluginDescriptorRef().getId();
            }
            if (pluginTypeId != null) {
                for (PluginDescriptor pluginDescriptor : PluginEnum.IDP_ADAPTER.getPluginManager().getInstalledDescriptors()) {
                    if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
                    Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
                    if (descriptorAttrs != null) {
                        coreAttrs = descriptorAttrs;
                    }
                    pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
                    break;
                }
            }
            boolean hasAtLeastOnePseudonym = false;
            int i = 0;
            for (IdpAdapterAttribute idpAdapterAttribute : this.apiAdapter.getAttributeContract().getCoreAttributes()) {
                attributes.add(idpAdapterAttribute);
                if (StringUtils.isNotBlank((String)idpAdapterAttribute.getName())) {
                    if (!coreAttrs.contains(idpAdapterAttribute.getName())) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.attribute_contract_unknown_core_attribute, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getCoreContractAttribute(i)), new Object[]{idpAdapterAttribute.getName()}));
                    } else if (idpAdapterAttribute.isPseudonym()) {
                        hasAtLeastOnePseudonym = true;
                    }
                }
                ++i;
            }
            List<IdpAdapterAttribute> extendedAttrs = this.apiAdapter.getAttributeContract().getExtendedAttributes();
            if (!pluginAllowsExtAttrs && extendedAttrs != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes())));
            }
            if (pluginAllowsExtAttrs && extendedAttrs != null) {
                for (IdpAdapterAttribute apiAttr : extendedAttrs) {
                    if (!apiAttr.isPseudonym()) continue;
                    hasAtLeastOnePseudonym = true;
                    break;
                }
            }
            AttributeContractValidator<IdpAdapterAttribute> attributeContractValidator = new AttributeContractValidator<IdpAdapterAttribute>(attributes, extendedAttrs, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getAttributeContract()));
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
            if (!hasAtLeastOnePseudonym) {
                this.appendError(this.errorFactory.create(ApiMessageKey.idp_adapter_one_pseudonym_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getAttributeContract())));
            }
            UniqueUserKeyAttributeValidator uniqueUserKeyAttributeValidator = new UniqueUserKeyAttributeValidator(this.apiAdapter.getAttributeContract().getUniqueUserKeyAttribute(), attributes, extendedAttrs, this.getParentPath(), this.apiAdapter.getPluginDescriptorRef(), this.apiAdapter.getConfiguration());
            uniqueUserKeyAttributeValidator.validate();
            this.appendErrors(uniqueUserKeyAttributeValidator.getErrors());
        }
        return !this.hasErrors();
    }

    private void validateAuthnCtxClassRef() {
        for (PluginDescriptor pluginDescriptor : PluginEnum.IDP_ADAPTER.getPluginManager().getInstalledDescriptors()) {
            if (!pluginDescriptor.getPluginClassName().equals(this.apiAdapter.getPluginDescriptorRef().getId())) continue;
            IdpAuthnAdapterDescriptor idpAuthnAdapterDescriptor = (IdpAuthnAdapterDescriptor)pluginDescriptor;
            if (idpAuthnAdapterDescriptor.allowConfigurableAuthnCtx() || !StringUtils.isNotEmpty((String)this.apiAdapter.getAuthnCtxClassRef())) break;
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_adapter_unsupported_authn_ctx, this.appendFieldPath(this.getParentPath(), IdpAdapterPaths.getAuthnCtxClassRef())));
            break;
        }
        ConfigStore configStore = ConfigStoreFarm.getConfig(AuthnCtxChecker.class);
        try {
            Map authnLevel = configStore.getMapValue("authentication-level");
            if (StringUtils.isEmpty((String)((String)authnLevel.get(this.apiAdapter.getAuthnCtxClassRef())))) {
                this.appendError(this.errorFactory.create(ApiMessageKey.idp_adapter_invalid_authn_ctx, this.appendFieldPath(this.getParentPath(), IdpAdapterPaths.getAuthnCtxClassRef())));
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
    }
}

