/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeQueryNameMapping;
import com.pingidentity.admin.api.model.IdpAttributeQuery;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class IdpAttributeQueryValidator
extends AbstractValidator {
    private IdpConnection connection;

    public IdpAttributeQueryValidator(IdpConnection connection) {
        this.connection = connection;
    }

    public boolean validate() {
        IdpAttributeQuery attributeQuery = this.connection.getAttributeQuery();
        if (attributeQuery == null) {
            return true;
        }
        if (this.connection.getBrowserSso() != null && this.connection.getBrowserSso().getProtocol() != Protocol.SAML20) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_query_saml2, ConnectionPaths.getAttributeQuery()));
        }
        if (StringUtils.isNotBlank((String)attributeQuery.getUrl())) {
            boolean isBaseUrlDefined = this.connection.getBaseUrl() != null;
            PartnerUrlValidator partnerUrlValidator = PartnerUrlValidatorFactory.getGenericValidator(attributeQuery.getUrl(), isBaseUrlDefined, ConnectionPaths.getAttributeQueryUrl());
            partnerUrlValidator.validate();
            this.getErrors().addAll(partnerUrlValidator.getErrors());
        } else {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.url_required, ConnectionPaths.getAttributeQueryUrl()));
        }
        if (this.validateAttributeQueryNameMappingListNullEntries(attributeQuery)) {
            HashSet<String> localNames = new HashSet<String>();
            HashSet<String> remoteNames = new HashSet<String>();
            for (int i = 0; i < attributeQuery.getNameMappings().size(); ++i) {
                AttributeQueryNameMapping mapping = attributeQuery.getNameMappings().get(i);
                this.validateName(i, mapping.getLocalName(), localNames, ConnectionPaths.getAttributeQueryNameMappingLocalName(i));
                this.validateName(i, mapping.getRemoteName(), remoteNames, ConnectionPaths.getAttributeQueryNameMappingRemoteName(i));
            }
        }
        return !this.hasErrors();
    }

    private boolean validateAttributeQueryNameMappingListNullEntries(IdpAttributeQuery attributeQuery) {
        if (CollectionUtils.isNotEmpty(attributeQuery.getNameMappings())) {
            int i = 0;
            for (AttributeQueryNameMapping attributeQueryNameMapping : attributeQuery.getNameMappings()) {
                if (attributeQueryNameMapping == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getAttributeQueryNameMapping(i)));
                }
                ++i;
            }
        }
        return !this.hasErrors();
    }

    private void validateName(int index, String name, Set<String> names, String fieldPath) {
        if (StringUtils.isBlank((String)name)) {
            String friendlyName = fieldPath.substring(fieldPath.lastIndexOf(".") + 1).trim();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, fieldPath, new Object[]{friendlyName}));
        } else {
            boolean success = names.add(name);
            if (!success) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_query_name_exists, fieldPath));
            }
        }
    }
}

