/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ConnectionSigningSettingsValidator;
import com.pingidentity.admin.api.validator.EncryptionSettingsValidator;
import com.pingidentity.admin.api.validator.IdpDecryptionKeyPairValidator;
import com.pingidentity.admin.api.validator.IdpEncryptionValidator;
import com.pingidentity.admin.api.validator.InboundBackChannelValidator;
import com.pingidentity.admin.api.validator.OutboundBackChannelValidator;
import com.pingidentity.admin.api.validator.VerificationCertValidator;
import com.pingidentity.admin.api.validator.VerificationSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.sourceid.saml20.domain.ConnectionBase;

public class IdpCredentialsValidator
extends CompositeValidator {
    private final IdpConnection idpConnection;

    public IdpCredentialsValidator(boolean isUpdate, ConnectionBase existingConn, IdpConnection connection, ValidatorRegistry validatorRegistry, boolean fullValidationPath) {
        this.idpConnection = connection;
        VerificationCertValidator certValidator = null;
        if (connection.getCredentials() != null) {
            certValidator = new VerificationCertValidator(isUpdate, existingConn, connection.getCredentials().getCerts(), fullValidationPath);
            validatorRegistry.register(VerificationCertValidator.class, (Validator)certValidator);
            this.addValidator((Validator)certValidator);
            this.addValidator((Validator)new OutboundBackChannelValidator(connection));
            this.addValidator((Validator)new InboundBackChannelValidator(connection, existingConn, isUpdate, validatorRegistry, fullValidationPath));
        }
        VerificationSettingsValidator verificationSettingsValidator = new VerificationSettingsValidator(connection, certValidator, fullValidationPath);
        validatorRegistry.register(VerificationSettingsValidator.class, (Validator)verificationSettingsValidator);
        this.addValidator((Validator)verificationSettingsValidator);
        this.addValidator((Validator)new ConnectionSigningSettingsValidator(connection, fullValidationPath));
        this.addValidator((Validator)new IdpDecryptionKeyPairValidator(connection, fullValidationPath));
        IdpEncryptionValidator encryptionValidator = new IdpEncryptionValidator(connection, fullValidationPath);
        validatorRegistry.register(EncryptionSettingsValidator.class, (Validator)encryptionValidator);
        this.addValidator((Validator)encryptionValidator);
    }

    @Override
    public boolean validate() {
        if (this.idpConnection.getCredentials() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.credentials_required, ConnectionPaths.getCredentials()));
            return false;
        }
        return super.validate();
    }
}

