/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractSsoServiceEndpointValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.HashSet;
import java.util.Set;

public class IdpSsoServiceEndpointsValidator
extends AbstractSsoServiceEndpointValidator {
    private static final Set<Binding> supportedEndpointBindings = new HashSet<Binding>();

    public IdpSsoServiceEndpointsValidator(IdpConnection connection) {
        super(connection.getIdpBrowserSso().getSsoServiceEndpoints(), connection.getIdpBrowserSso().getEnabledProfiles() != null && connection.getIdpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SSO), connection.getBaseUrl() != null, connection.getIdpBrowserSso().getProtocol(), connection.getType().getRole());
    }

    @Override
    public boolean validate() {
        boolean isOIDC;
        boolean bl = isOIDC = this.protocol == Protocol.OIDC;
        if (!this.spInitSsoEnabled || isOIDC) {
            if (this.ssoEndpoints != null && !this.ssoEndpoints.isEmpty() && this.protocol != Protocol.WSFED) {
                ApiMessageKey error = ApiMessageKey.sso_service_endpoints_not_required;
                if (isOIDC) {
                    error = ApiMessageKey.field_not_required;
                }
                this.appendError(ValidationErrorFactory.getInstance().create(error, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role), new Object[]{ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)}));
                return false;
            }
            if (this.protocol != Protocol.WSFED) {
                return true;
            }
        }
        return super.validate();
    }

    @Override
    protected Set<Binding> getSupportedBindings() {
        return supportedEndpointBindings;
    }

    static {
        supportedEndpointBindings.add(Binding.ARTIFACT);
        supportedEndpointBindings.add(Binding.POST);
        supportedEndpointBindings.add(Binding.REDIRECT);
    }
}

