/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.RequestSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TokenSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;

public class IdpWsTrustTokenMappingValidator
extends BaseAttributeDataSourceValidator {
    private SpWsTrust wsTrustSettings;
    private IdpTokenProcessorMapping mapping;
    private int index;

    public IdpWsTrustTokenMappingValidator(IdpTokenProcessorMapping mapping, int index, SpWsTrust wsTrustSettings, ValidatorContext context) {
        super(context);
        this.mapping = mapping;
        this.index = index;
        this.wsTrustSettings = wsTrustSettings;
    }

    @Override
    public boolean validate() {
        WsTrustRequestContract contract;
        ResourceIdValidator resourceIdValidator = new ResourceIdValidator(this.mapping.getIdpTokenProcessorRef(), "IdP Token Processor reference", ConnectionPaths.WsTrustPaths.getTokenProcessorMappingRef(this.index));
        this.addValidator((Validator)resourceIdValidator);
        if (!super.validate()) {
            return false;
        }
        PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)MgmtFactory.getTokenProcessorManager(), this.mapping.getIdpTokenProcessorRef().getId(), ConnectionPaths.WsTrustPaths.getTokenProcessorMappingRefId(this.index), ApiMessageKey.token_processor_not_found, true);
        this.addValidator((Validator)pluginExistsValidator);
        if (!super.validate()) {
            return false;
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> sources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        sources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        sources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        sources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        TokenSourceTypeValidatorBuilder tokenTypeBuilder = this.createTokenTypeBuilder(this.mapping.getIdpTokenProcessorRef().getId());
        sources.put(new SourceTypeIdKey(SourceType.TOKEN), tokenTypeBuilder);
        sources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            sources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        if (this.wsTrustSettings.getRequestContractRef() != null && (contract = MgmtFactory.getWsTrustRequestContractManager().findById(this.wsTrustSettings.getRequestContractRef().getId())) != null) {
            sources.put(new SourceTypeIdKey(SourceType.REQUEST), this.createRequestValBuilder(contract));
        }
        int attributeSourceIndex = 0;
        for (AttributeSource attributeSource : this.mapping.getAttributeSources()) {
            NotBlankValidator validator = new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", ConnectionPaths.WsTrustPaths.getAttributeSourceId(this.index, attributeSourceIndex));
            this.addValidator((Validator)validator);
            ++attributeSourceIndex;
        }
        this.mapDataStoreTypesToDsValidators(this.mapping, sources);
        WsTrustTokenAttributeContract wsTrustTokenAttributeContract = new WsTrustTokenAttributeContract();
        HashSet<String> contract2 = new HashSet<String>();
        contract2.addAll(wsTrustTokenAttributeContract.getImmutableAttributeNames());
        Set mutableContractNames = this.wsTrustSettings.getAttributeContract().getExtendedAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        contract2.addAll(mutableContractNames);
        AttributeMappingValidator attributeMappingValidator = new AttributeMappingValidator(this.mapping, contract2, tokenTypeBuilder.getExposedSubstitutionVariables(), null, sources, ConnectionPaths.WsTrustPaths.getTokenProcessorMappings(), this.getContext());
        this.addValidator((Validator)attributeMappingValidator);
        super.validate();
        return !this.hasErrors();
    }

    private TokenSourceTypeValidatorBuilder createTokenTypeBuilder(String instanceId) {
        TokenPluginInstance instance = (TokenPluginInstance)MgmtFactory.getTokenProcessorManager().getInstance(instanceId);
        HashSet<String> srcNames = new HashSet<String>();
        if (instance != null) {
            srcNames.addAll(instance.getAttributeContract().getAllAttrNamesSorted());
        }
        return new TokenSourceTypeValidatorBuilder(srcNames);
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForWSTrustTokenProc());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private RequestSourceTypeValidatorBuilder createRequestValBuilder(WsTrustRequestContract contract) {
        HashSet<String> srcNames = new HashSet<String>();
        srcNames.addAll(contract.getAllAttrNamesSorted());
        return new RequestSourceTypeValidatorBuilder(srcNames);
    }
}

