/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.MetadataUrlCertPair;

public class ImportMetadataUrlValidator
extends AbstractValidator {
    public static final Integer NONE = new Integer(0);
    public static final Integer FILE = new Integer(1);
    public static final Integer URL = new Integer(2);
    String prevMetadataUrl;
    MetadataUrlCertPair selectedMetadataPair;
    boolean isUrlRequired = true;
    Integer metadataType;
    boolean validateLoadClicked = false;

    public ImportMetadataUrlValidator(String prevMetadataUrl, MetadataUrlCertPair selectedMetadataPair, boolean isUrlRequired, Integer metadataType) {
        this.prevMetadataUrl = prevMetadataUrl;
        this.selectedMetadataPair = selectedMetadataPair;
        this.isUrlRequired = isUrlRequired;
        this.metadataType = metadataType;
    }

    public boolean isValidateLoadClicked() {
        return this.validateLoadClicked;
    }

    public void setValidateLoadClicked(boolean validateLoadClicked) {
        this.validateLoadClicked = validateLoadClicked;
    }

    public boolean validate() {
        if (this.metadataType.equals(URL)) {
            if (this.selectedMetadataPair == null && this.isUrlRequired) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_no_url, null));
            }
            if (this.validateLoadClicked && this.hasMetadataUrlChanged()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_load_from_URL, null));
            }
        }
        return !this.hasErrors();
    }

    private boolean hasMetadataUrlChanged() {
        if (StringUtils.isBlank((String)this.prevMetadataUrl)) {
            return this.selectedMetadataPair != null;
        }
        if (this.selectedMetadataPair != null) {
            return !this.prevMetadataUrl.equals(this.selectedMetadataPair.getUrl());
        }
        return false;
    }
}

