/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;

public class InboundBackChannelAuthTypeValidator
extends AbstractValidator {
    protected final boolean needAtLeastBasicOrCert;
    protected final boolean cert;
    protected final boolean basic;
    protected final boolean none;
    private final String backChannelAuthPath;

    public InboundBackChannelAuthTypeValidator(boolean cert, boolean basic, boolean none, boolean needAtLeastBasicOrCert) {
        this(cert, basic, none, needAtLeastBasicOrCert, ConnectionPaths.getInboundBackChannelAuth());
    }

    public InboundBackChannelAuthTypeValidator(boolean cert, boolean basic, boolean none, boolean needAtLeastBasicOrCert, String backChannelAuthPath) {
        this.cert = cert;
        this.basic = basic;
        this.none = none;
        this.needAtLeastBasicOrCert = needAtLeastBasicOrCert;
        this.backChannelAuthPath = backChannelAuthPath;
    }

    public boolean validate() {
        if (!this.cert && !this.basic && this.needAtLeastBasicOrCert) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.backchannelauth_cert_or_basic_required, this.backChannelAuthPath));
        } else if (!(this.cert || this.basic || this.none)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.backchannelauth_valid_authentication_method_required, this.backChannelAuthPath));
        }
        return !this.hasErrors();
    }
}

