/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.sso.idp.Scim2SchemaAttribute;
import com.pingidentity.admin.api.model.sso.idp.Scim2SchemaSubAttribute;
import com.pingidentity.admin.api.validator.InboundProvisioningCustomScim2AttributesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.scim.model.ScimAttributeType;
import org.sourceid.saml20.domain.scim.util.CustomAttributesUtil;

public class InboundProvisioningCustomScim2AttributeValidator
extends InboundProvisioningCustomScim2AttributesValidator {
    private ScimAttributeType attributeType;
    private List<String> subAttributeNames;
    private List<String> canonicalValues;
    private boolean isMultivalued;
    private String errorPath;

    public InboundProvisioningCustomScim2AttributeValidator() {
    }

    public InboundProvisioningCustomScim2AttributeValidator(String nameSpace, Scim2SchemaAttribute attribute, String errorPath) {
        this.attributeName = attribute.getName();
        this.schema = nameSpace;
        this.canonicalValues = attribute.getCanonicalValues();
        this.isMultivalued = attribute.isMultiValued();
        this.errorPath = errorPath;
        this.subAttributeNames = new ArrayList<String>();
        if (attribute.getSubAttributes() != null) {
            attribute.getSubAttributes().stream().map(Scim2SchemaSubAttribute::getName).forEach(this.subAttributeNames::add);
        }
    }

    @Override
    public boolean validate() {
        this.validateAttributeName();
        this.validateAttributeType();
        this.validateSubAttributes();
        this.validateCanonicalValues();
        this.validateSchema();
        if (!this.hasErrors()) {
            List customAttributeIds = CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)this.attributeName, this.canonicalValues, this.subAttributeNames, (boolean)this.isMultivalued);
            for (String customAttributeId : customAttributeIds) {
                this.validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(customAttributeId);
            }
        }
        return !this.hasErrors();
    }

    private void validateAttributeType() {
        if (ScimAttributeType.COMPLEX.equals((Object)this.attributeType) && (this.subAttributeNames == null || this.subAttributeNames.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attributes_count, "inbound_provisioning_custom_attribute_sub_attributes"));
        }
    }

    private void validateCanonicalValues() {
        if (this.isMultivalued && this.subAttributeNames != null && !this.subAttributeNames.isEmpty() && (this.canonicalValues == null || this.canonicalValues.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attribute_types_count, this.errorPath == null ? "inbound_provisioning_custom_attribute_canonical_values" : this.errorPath));
        }
        if (this.canonicalValues != null) {
            for (String canonicalValue : this.canonicalValues) {
                if (StringUtils.isAlphanumeric((String)canonicalValue)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_type_invalid_alphanumeric_only, this.errorPath == null ? "inbound_provisioning_custom_attribute_canonical_values" : this.errorPath));
            }
            if ((long)this.canonicalValues.size() != this.canonicalValues.stream().distinct().count()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_entry, this.errorPath == null ? "inbound_provisioning_custom_attribute_canonical_values" : this.errorPath));
            }
        }
    }

    public void validateSubAttributes() {
        if (this.subAttributeNames != null && !this.subAttributeNames.isEmpty()) {
            for (String subAttributeName : this.subAttributeNames) {
                if (StringUtils.isEmpty((String)subAttributeName)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attr_name_required, "inbound_provisioning_custom_attribute_sub_attributes"));
                }
                if (!this.isMultivalued) continue;
                if ("type".equals(subAttributeName)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attributes_name, this.errorPath == null ? "inbound_provisioning_custom_attribute_sub_attributes" : this.errorPath));
                    continue;
                }
                if (this.canonicalValues == null || !this.canonicalValues.contains(subAttributeName)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attributes_cant_be_canonical, this.errorPath == null ? "inbound_provisioning_custom_attribute_sub_attributes" : this.errorPath));
            }
            HashSet<String> uniqueSubAttributes = new HashSet<String>();
            for (String subAttributeName : this.subAttributeNames) {
                if (uniqueSubAttributes.add(subAttributeName)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attr_name_duplicate, "inbound_provisioning_custom_attribute_sub_attributes", new Object[]{subAttributeName}));
            }
        }
    }

    public static class Builder {
        private String attributeName;
        private ScimAttributeType attributeType;
        private List<String> subAttributeNames;
        private List<String> canonicalValues;
        private boolean multivalued;

        public Builder setAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder setAttributeType(ScimAttributeType attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public Builder setSubAttributeNames(List<String> subAttributeNames) {
            this.subAttributeNames = subAttributeNames;
            return this;
        }

        public Builder setCanonicalValues(List<String> canonicalValues) {
            this.canonicalValues = canonicalValues;
            return this;
        }

        public Builder setMultivalued(boolean multivalued) {
            this.multivalued = multivalued;
            return this;
        }

        public InboundProvisioningCustomScim2AttributeValidator build() {
            InboundProvisioningCustomScim2AttributeValidator validator = new InboundProvisioningCustomScim2AttributeValidator();
            validator.attributeName = this.attributeName;
            validator.attributeType = this.attributeType;
            validator.subAttributeNames = this.subAttributeNames;
            validator.canonicalValues = this.canonicalValues;
            validator.isMultivalued = this.multivalued;
            return validator;
        }
    }
}

