/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.validator.InboundProvisioningCustomScimAttributesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.scim.util.CustomAttributesUtil;

public class InboundProvisioningCustomScimAttributeValidator
extends InboundProvisioningCustomScimAttributesValidator {
    private boolean multiValued;
    private boolean isLdapUserRepositoryType;
    private List<String> subAttributesNamesList = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();
    private String errorPath = null;
    private boolean isAPI = false;

    public InboundProvisioningCustomScimAttributeValidator() {
    }

    public InboundProvisioningCustomScimAttributeValidator(Builder builder) {
        this.attributeName = builder.attributeName;
        this.schema = builder.schema;
        this.multiValued = builder.multiValued;
        this.subAttributesNamesList = builder.subAttributesNamesList;
        this.types = builder.types;
        this.idpConnEntityId = builder.idpConnEntityId;
        this.theOtherAttributeNames = builder.theOtherAttributeNames;
        this.isLdapUserRepositoryType = builder.isLdapUserRepositoryType;
    }

    public InboundProvisioningCustomScimAttributeValidator(String nameSpace, SchemaAttribute attribute, List<String> otherAttributeNames, String errorPath) {
        this.attributeName = attribute.getName();
        this.schema = nameSpace;
        this.multiValued = attribute.isMultiValued();
        this.subAttributesNamesList = attribute.getSubAttributes();
        this.types = attribute.getTypes();
        this.theOtherAttributeNames = otherAttributeNames;
        this.errorPath = errorPath;
        this.isAPI = true;
        this.isLdapUserRepositoryType = true;
    }

    @Override
    public boolean validate() {
        this.validateAttributeName();
        this.validateSubAttributes();
        this.validateTypes();
        this.validateSchema();
        if (!this.hasErrors()) {
            List customAttributeIds = CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)this.attributeName, this.types, this.subAttributesNamesList, (boolean)this.multiValued);
            for (String customAttributeId : customAttributeIds) {
                this.validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(customAttributeId);
            }
        }
        return !this.hasErrors();
    }

    private void validateSubAttributes() {
        if (this.multiValued && this.types != null && !this.types.isEmpty()) {
            HashSet<String> uniqueSubType = new HashSet<String>();
            if (this.subAttributesNamesList == null || this.subAttributesNamesList.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attributes_count, this.errorPath == null ? "inbound_provisioning_custom_attribute_sub_attributes" : this.errorPath));
            } else {
                for (String subAttrName : this.subAttributesNamesList) {
                    if (subAttrName == null) continue;
                    if (subAttrName.equals("type")) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attributes_name, this.errorPath == null ? "inbound_provisioning_custom_attribute_sub_attributes" : this.errorPath));
                    }
                    if (!this.isAPI) continue;
                    this.addDuplicateError(subAttrName, uniqueSubType, "sub-attributes");
                }
            }
        }
        if (this.subAttributesNamesList != null) {
            for (String subAttrName : this.subAttributesNamesList) {
                if (StringUtils.isAlphanumeric((String)subAttrName)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_sub_attribute_name_invalid_alphanumeric_only, this.errorPath == null ? "inbound_provisioning_custom_attribute_sub_attributes" : this.errorPath));
            }
        }
    }

    private void addDuplicateError(String entry, Set<String> existingEntries, String attributeType) {
        if (existingEntries.contains(entry)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_entry, this.errorPath, new Object[]{attributeType, entry}));
        } else {
            existingEntries.add(entry);
        }
    }

    private void validateTypes() {
        if (this.multiValued && this.subAttributesNamesList != null && !this.subAttributesNamesList.isEmpty() && this.isLdapUserRepositoryType && (this.types == null || this.types.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attribute_types_count, this.errorPath == null ? "inbound_provisioning_custom_attribute_canonical_values" : this.errorPath));
        }
        if (this.types != null) {
            HashSet<String> uniqueType = new HashSet<String>();
            for (String type : this.types) {
                if (!StringUtils.isAlphanumeric((String)type)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_type_invalid_alphanumeric_only, this.errorPath == null ? "inbound_provisioning_custom_attribute_types" : this.errorPath));
                }
                if (!this.isAPI || type == null) continue;
                this.addDuplicateError(type, uniqueType, "types");
            }
        }
    }

    public static class Builder {
        private String attributeName;
        private String schema;
        private boolean multiValued;
        private List<String> subAttributesNamesList = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();
        private String idpConnEntityId;
        private List<String> theOtherAttributeNames;
        private boolean isLdapUserRepositoryType;

        public Builder setAttributeName(String name) {
            this.attributeName = name;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder setMultiValued(boolean isMultiValued) {
            this.multiValued = isMultiValued;
            return this;
        }

        public Builder setSubAttributesNamesList(List<String> subAttrsNames) {
            this.subAttributesNamesList = subAttrsNames;
            return this;
        }

        public Builder setTypes(List<String> types) {
            this.types = types;
            return this;
        }

        public Builder setIdpConnEntityId(String id) {
            this.idpConnEntityId = id;
            return this;
        }

        public Builder setTheOtherAttributeNames(List<String> otherAttributeNames) {
            this.theOtherAttributeNames = otherAttributeNames;
            return this;
        }

        public Builder setLdapUserRepositoryType(boolean isLdapType) {
            this.isLdapUserRepositoryType = isLdapType;
            return this;
        }

        public InboundProvisioningCustomScimAttributeValidator build() {
            return new InboundProvisioningCustomScimAttributeValidator(this);
        }
    }
}

