/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class InputContractSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final SourceType sourceType = SourceType.INPUTS;
    private final List<String> inputAttributes;

    public InputContractSourceTypeValidatorBuilder(List<String> inputAttributes) {
        this.inputAttributes = inputAttributes;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.sourceType);
        return new InputContractSourceTypeValidator(this.inputAttributes, afv.getValue(), attributePath);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.sourceType);
        InputContractSourceTypeValidator validator = new InputContractSourceTypeValidator(this.inputAttributes, icEntry.getAttributeName(), attributePath);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)validator, icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return this.inputAttributes.stream().map(param -> "fragment.inputs." + param).collect(Collectors.toSet());
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    private static class InputContractSourceTypeValidator
    extends AbstractValidator {
        private final List<String> inputAttributes;
        private final String valueToLookFor;
        private final String fieldPath;

        public InputContractSourceTypeValidator(List<String> inputAttributes, String valueToLookFor, String fieldPath) {
            this.inputAttributes = inputAttributes;
            this.valueToLookFor = valueToLookFor;
            this.fieldPath = fieldPath;
        }

        public boolean validate() {
            if (this.inputAttributes == null || !this.inputAttributes.contains(this.valueToLookFor)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.source_type_invalid_inputs, this.fieldPath, new Object[]{this.valueToLookFor}));
            }
            return !this.hasErrors();
        }
    }
}

