/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.JdbcDataStore;
import com.pingidentity.admin.api.model.fieldpaths.JdbcDataStorePaths;
import com.pingidentity.admin.api.validator.AdvancedJdbcDataStoreValidator;
import com.pingidentity.admin.api.validator.DataStoreBaseValidator;
import com.pingidentity.admin.api.validator.JdbcConnectionUrlValidator;
import com.pingidentity.admin.api.validator.JdbcDefaultInstanceValidator;
import com.pingidentity.admin.api.validator.JdbcTagConfigValidator;
import com.pingidentity.admin.api.validator.SecretReferenceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class JdbcDataStoreValidator
extends DataStoreBaseValidator {
    private final String connectionUrl;
    private final String driverClass;
    private final String password;
    private final boolean useSecretManager;

    private JdbcDataStoreValidator(Builder builder) {
        String pass;
        this.isCreate = builder.isCreate;
        this.name = builder.name;
        this.id = builder.id;
        this.password = builder.password;
        this.encryptedPassword = builder.encryptedPassword;
        this.connectionUrl = builder.connectionUrl;
        this.driverClass = builder.driverClass;
        this.useSecretManager = builder.useSecretManager;
        if (builder.advancedJdbcDataStoreValidator != null) {
            this.addValidator((Validator)builder.advancedJdbcDataStoreValidator);
        }
        if (builder.jdbcTagConfigValidator != null) {
            this.addValidator((Validator)builder.jdbcTagConfigValidator);
        }
        if (builder.jdbcDefaultInstanceValidator != null) {
            this.addValidator((Validator)builder.jdbcDefaultInstanceValidator);
        }
        if (builder.validateConnectionUrl) {
            this.addValidator((Validator)new JdbcConnectionUrlValidator(builder.connectionUrl, JdbcDataStorePaths.getConnectionUrl()));
        }
        String string = pass = builder.useSecretManager ? this.password : this.encryptedPassword;
        if (SecretReferenceUtil.isSecretReference((String)pass) || builder.useSecretManager) {
            this.addValidator((Validator)new SecretReferenceValidator(pass, JdbcDataStorePaths.getEncryptedPassword()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validatePassword();
        this.validateDriverClass();
        return !this.hasErrors();
    }

    @Override
    public boolean requirePasswordCheck() {
        return true;
    }

    private void validateDriverClass() {
        if (!ValidationUtil.isValidClassName((String)this.driverClass)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_invalid_driver_class, JdbcDataStorePaths.getDriverClass()));
        }
    }

    private void validatePassword() {
        if (!this.useSecretManager && StringUtils.isNotBlank((String)this.password) && SecretReferenceUtil.isSecretReference((String)this.password)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_invalid_password_secret_reference, JdbcDataStorePaths.getPassword()));
        }
    }

    public static class Builder {
        private boolean isCreate;
        private String id;
        private String connectionUrl;
        private String driverClass;
        private String password;
        private String encryptedPassword;
        private boolean useSecretManager = false;
        private String name;
        private AdvancedJdbcDataStoreValidator advancedJdbcDataStoreValidator;
        private JdbcTagConfigValidator jdbcTagConfigValidator;
        private JdbcDefaultInstanceValidator jdbcDefaultInstanceValidator;
        private boolean validateConnectionUrl = true;

        public Builder withDataStore(JdbcDataStore dataStore) {
            this.id = dataStore.getId();
            this.connectionUrl = dataStore.getConnectionUrl();
            this.driverClass = dataStore.getDriverClass();
            this.password = dataStore.getPassword();
            this.encryptedPassword = dataStore.getEncryptedPassword();
            this.name = dataStore.getName();
            return this;
        }

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setConnectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            return this;
        }

        public Builder setDriverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public Builder setUseSecretManager(boolean useSecretManager) {
            this.useSecretManager = useSecretManager;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdvancedJdbcDataStoreValidator(AdvancedJdbcDataStoreValidator advancedJdbcDataStoreValidator) {
            this.advancedJdbcDataStoreValidator = advancedJdbcDataStoreValidator;
            return this;
        }

        public Builder setJdbcTagConfigValidator(JdbcTagConfigValidator jdbcTagConfigValidator) {
            this.jdbcTagConfigValidator = jdbcTagConfigValidator;
            return this;
        }

        public Builder setValidateConnectionUrl(boolean validateConnectionUrl) {
            this.validateConnectionUrl = validateConnectionUrl;
            return this;
        }

        public Builder setJdbcDefaultInstanceValidator(JdbcDefaultInstanceValidator jdbcDefaultInstanceValidator) {
            this.jdbcDefaultInstanceValidator = jdbcDefaultInstanceValidator;
            return this;
        }

        public JdbcDataStoreValidator build() {
            return new JdbcDataStoreValidator(this);
        }
    }
}

