/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.JdbcDataStorePaths;
import com.pingidentity.admin.api.model.fieldpaths.JdbcTagPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;

public class JdbcDefaultInstanceValidator
extends AbstractValidator {
    private List<JdbcTagConfig> tagConfigList;
    private JdbcInstanceIdentifier defaultInstance;

    public JdbcDefaultInstanceValidator(List<JdbcTagConfig> tagConfigList, JdbcInstanceIdentifier defaultInstance) {
        this.tagConfigList = tagConfigList;
        this.defaultInstance = defaultInstance;
    }

    void validateDefaultAndTagListDefaultMatch() {
        if (CollectionUtils.isNotEmpty(this.tagConfigList)) {
            for (JdbcTagConfig tagConfig : this.tagConfigList) {
                if (!tagConfig.isDefaultSource() || Objects.equals(tagConfig.getIdentifier(), this.defaultInstance)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_mismatched_default_connection_url, JdbcDataStorePaths.getConnectionUrl()));
                break;
            }
        } else if (this.defaultInstance != null && StringUtils.isNotEmpty((String)this.defaultInstance.getJdbcUrl())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_missing_default_connection_url, JdbcTagPaths.getTagArrayPath()));
        }
    }

    public boolean validate() {
        this.validateDefaultAndTagListDefaultMatch();
        return !this.hasErrors();
    }
}

