/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeQueryNameMapping;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioning;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioningUserAttributes;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.DataStoreRepositoryValidator;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdpBrowserSsoValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.RepositoryAttributeFulfillmentValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;

public class JitProvisioningValidator
extends CompositeValidator {
    private IdpBrowserSso browserSso;
    private JitProvisioning jitProvisioning;
    private JitProvisioningUserAttributes userAttributes;
    private DataStoreRepository userRepository;

    public JitProvisioningValidator(IdpConnection connection, DataSourceManager dsManager, ValidatorContext context) {
        this.browserSso = connection.getIdpBrowserSso();
        this.jitProvisioning = this.browserSso.getJitProvisioning();
        if (this.jitProvisioning != null) {
            this.userAttributes = this.jitProvisioning.getUserAttributes();
            this.userRepository = this.jitProvisioning.getUserRepository();
            this.addValidator((Validator)new NotNullValidator(this.userAttributes, "User Attributes", ConnectionPaths.getJitProvisioningUserAttributes()));
            if (this.userRepository != null) {
                ArrayList<String> availableVars = new ArrayList<String>();
                IdpBrowserSsoAttributeContract attributeContract = this.browserSso.getAttributeContract();
                if (attributeContract != null) {
                    for (IdpBrowserSsoAttribute coreAttribute : attributeContract.getCoreAttributes()) {
                        if (coreAttribute.getName() == null) continue;
                        availableVars.add(coreAttribute.getName());
                    }
                    for (IdpBrowserSsoAttribute extendedAttribute : attributeContract.getExtendedAttributes()) {
                        if (extendedAttribute.getName() == null) continue;
                        availableVars.add(extendedAttribute.getName());
                    }
                }
                Validator dataStoreRepositoryValidator = DataStoreRepositoryValidator.getInstance(this.jitProvisioning, availableVars, dsManager, context);
                this.addValidator(dataStoreRepositoryValidator);
                Map<String, AttributeFulfillmentValue> jitRepositoryAttributeMapping = this.userRepository.getJitRepositoryAttributeMapping();
                if (jitRepositoryAttributeMapping != null && !jitRepositoryAttributeMapping.isEmpty()) {
                    ExpressionManager expressionManager;
                    HashSet<SourceType> validSourceTypes = new HashSet<SourceType>();
                    HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                    if (this.userAttributes != null && this.userAttributes.isDoAttributeQuery()) {
                        HashSet<String> validAttributeQueryNames = new HashSet<String>();
                        List<AttributeQueryNameMapping> attributeQueryNameMappings = connection.getAttributeQuery().getNameMappings();
                        for (AttributeQueryNameMapping attributeQueryNameMapping : attributeQueryNameMappings) {
                            validAttributeQueryNames.add("${" + attributeQueryNameMapping.getLocalName() + "}");
                        }
                        AttributeSetSourceTypeValidatorBuilder attributeQueryAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(validAttributeQueryNames, SourceType.ATTRIBUTE_QUERY);
                        validSourceTypes.add(SourceType.ATTRIBUTE_QUERY);
                        validSources.put(new SourceTypeIdKey(SourceType.ATTRIBUTE_QUERY), attributeQueryAttributeBuilder);
                    }
                    if ((expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsOn()) {
                        validSourceTypes.add(SourceType.EXPRESSION);
                        ExpressionSourceTypeValidatorBuilder expressionSourceTypeValidatorBuilder = new ExpressionSourceTypeValidatorBuilder(context);
                        expressionSourceTypeValidatorBuilder.setSubstitutionVariables(new HashSet<String>(availableVars));
                        validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), expressionSourceTypeValidatorBuilder);
                    }
                    validSourceTypes.add(SourceType.CONTEXT);
                    validSourceTypes.add(SourceType.NO_MAPPING);
                    validSourceTypes.add(SourceType.TEXT);
                    AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = IdpBrowserSsoValidator.createAssertionValBuilder(this.browserSso);
                    if (this.browserSso.getProtocol() == Protocol.OIDC) {
                        validSourceTypes.add(SourceType.CLAIMS);
                        validSources.put(new SourceTypeIdKey(SourceType.CLAIMS), assertionSourceTypeBuilder);
                    } else {
                        validSourceTypes.add(SourceType.ASSERTION);
                        validSources.put(new SourceTypeIdKey(SourceType.ASSERTION), assertionSourceTypeBuilder);
                    }
                    validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), IdpBrowserSsoValidator.createContextTypeBuilder(this.browserSso));
                    validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
                    validSources.put(new SourceTypeIdKey(SourceType.TEXT), IdpBrowserSsoValidator.createTextValBuilder());
                    Validator attributeFulfillmentValidator = RepositoryAttributeFulfillmentValidator.getInstance(this.userRepository, validSourceTypes, validSources, context);
                    if (attributeFulfillmentValidator != null) {
                        this.addValidator(attributeFulfillmentValidator);
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_attribute_mapping_required, ConnectionPaths.getJitProvisioningAttributeMapping()));
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_required, ConnectionPaths.getJitProvisioningUserRepository()));
            }
            this.addValidator((Validator)new NotNullValidator((Object)this.jitProvisioning.getErrorHandling(), "Error Handling", ConnectionPaths.getJitProvisioningErrorHandling()));
        }
    }
}

