/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.KeyLinkPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public final class KeyAndCertificateLinkValidator
extends CompositeValidator {
    static final String PRIVATE_KEY_ID_FRIENDLY_NAME = "Private Key Identifier";
    static final String CERTIFICATE_FRIENDLY_NAME = "Certificate Data";
    private final PrivateKeyAndCertificateValidator privateKeyIdValueValidator;

    public KeyAndCertificateLinkValidator(String privateKeyId, Cert cert, ValidationErrorFactory errorFactory, CertificateService certificateService, PkCertManager pkCertManager) {
        this.privateKeyIdValueValidator = new PrivateKeyAndCertificateValidator(privateKeyId, PRIVATE_KEY_ID_FRIENDLY_NAME, KeyLinkPaths.getPrivateKeyId(), cert.getX509Certificate(), CERTIFICATE_FRIENDLY_NAME, KeyLinkPaths.getCertificateData(), certificateService, pkCertManager, errorFactory);
        this.addValidator((Validator)this.privateKeyIdValueValidator);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKeyIdValueValidator.privateKey;
    }

    private static class PrivateKeyAndCertificateValidator
    extends AbstractValidator {
        private static final Log log = LogFactory.getLog(PrivateKeyAndCertificateValidator.class);
        private final String privateKeyId;
        private final String privateKeyIdFieldFriendlyName;
        private final String privateKeyIdFieldPath;
        private final X509Certificate x509Certificate;
        private final String x509CertificateFieldFriendlyName;
        private final String x509CertificateFieldPath;
        private final CertificateService certificateService;
        private final PkCertManager pkCertManager;
        private final ValidationErrorFactory errorFactory;
        private PrivateKey privateKey;

        private PrivateKeyAndCertificateValidator(String privateKeyId, String privateKeyIdFieldFriendlyName, String privateKeyIdFieldPath, X509Certificate x509Certificate, String x509CertificateFieldFriendlyName, String x509CertificateFieldPath, CertificateService certificateService, PkCertManager pkCertManager, ValidationErrorFactory errorFactory) {
            this.privateKeyId = privateKeyId;
            this.privateKeyIdFieldFriendlyName = privateKeyIdFieldFriendlyName;
            this.privateKeyIdFieldPath = privateKeyIdFieldPath;
            this.x509Certificate = x509Certificate;
            this.x509CertificateFieldFriendlyName = x509CertificateFieldFriendlyName;
            this.x509CertificateFieldPath = x509CertificateFieldPath;
            this.certificateService = certificateService;
            this.pkCertManager = pkCertManager;
            this.errorFactory = errorFactory;
        }

        public boolean validate() {
            if (StringUtils.isBlank((CharSequence)this.privateKeyId)) {
                return true;
            }
            if (this.pkCertManager.getPkCert(this.privateKeyId) != null) {
                log.debug((Object)("Private key with the '" + this.privateKeyId + "' key identifier is already linked to a certificate"));
                this.appendError(this.errorFactory.create(ApiMessageKey.cert_key_link_private_key_already_linked, this.privateKeyIdFieldPath, new Object[]{this.privateKeyIdFieldFriendlyName}));
                return false;
            }
            try {
                this.privateKey = this.certificateService.findPrivateKeyById(this.privateKeyId);
                if (this.privateKey == null) {
                    log.debug((Object)("Could not find a private key with the '" + this.privateKeyId + "' key identifier"));
                    this.appendError(this.errorFactory.create(ApiMessageKey.cert_key_link_private_key_not_found, this.privateKeyIdFieldPath, new Object[]{this.privateKeyIdFieldFriendlyName}));
                    return false;
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                this.appendError(this.errorFactory.create(ApiMessageKey.cert_key_link_private_key_lookup_failed, this.privateKeyIdFieldPath, new Object[]{this.privateKeyIdFieldFriendlyName}));
                log.error((Object)("failed to perform private key lookup due to: " + e.getMessage()));
                log.debug((Object)e);
                return false;
            }
            try {
                if (this.certificateService.doPrivateKeyAndCertificateMatch(this.privateKey, this.x509Certificate)) {
                    log.debug((Object)"Private key and certificate match");
                } else {
                    log.debug((Object)"Private key and certificate do not match");
                    this.appendError(this.errorFactory.create(ApiMessageKey.cert_key_link_private_key_certificate_mismatch, this.x509CertificateFieldPath, new Object[]{this.x509CertificateFieldFriendlyName}));
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
                this.appendError(this.errorFactory.create(ApiMessageKey.cert_key_link_private_key_certificate_match_failed, this.x509CertificateFieldPath, new Object[]{this.x509CertificateFieldFriendlyName}));
                log.error((Object)("failed to perform private key and certificate match due to: " + e.getMessage()));
                log.debug((Object)e);
            }
            return !this.hasErrors();
        }
    }
}

