/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.NewKeyPairSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class KeyRotationSettingsValidator
extends AbstractValidator {
    private String rotationBufferDaysStr;
    private String validDaysStr;
    private String keyAlgorithm;
    private String keySizeStr;
    private String signatureAlgorithm;
    private String rotationBufferName;

    public KeyRotationSettingsValidator(String rotationBufferDays, String validDays, String keyAlgorithm, String keySize, String signatureAlgorithm) {
        this.rotationBufferDaysStr = rotationBufferDays;
        this.validDaysStr = validDays;
        this.keyAlgorithm = keyAlgorithm;
        this.keySizeStr = keySize;
        this.signatureAlgorithm = signatureAlgorithm;
        this.rotationBufferName = "Rotation";
    }

    protected KeyRotationSettingsValidator(String rotationBufferDays, String validDays, String keyAlgorithm, String keySize, String signatureAlgorithm, String rotationBufferName) {
        this.rotationBufferDaysStr = rotationBufferDays;
        this.validDaysStr = validDays;
        this.keyAlgorithm = keyAlgorithm;
        this.keySizeStr = keySize;
        this.signatureAlgorithm = signatureAlgorithm;
        this.rotationBufferName = rotationBufferName;
    }

    public boolean validate() {
        String rotationBufferPath = this.getRotationBufferPathName();
        NewKeyPairSettingsValidator keyPairValidator = new NewKeyPairSettingsValidator("Common Name", "Organization", null, null, null, "US", this.validDaysStr, this.keyAlgorithm, this.keySizeStr, this.signatureAlgorithm);
        keyPairValidator.validate();
        this.appendErrors(keyPairValidator.getErrors());
        if (StringUtils.isBlank((String)this.rotationBufferDaysStr)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.key_rotation_buffer_required, rotationBufferPath, new Object[]{this.rotationBufferName}));
        } else {
            int rotationBufferDays = -1;
            try {
                rotationBufferDays = Integer.parseInt(this.rotationBufferDaysStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (rotationBufferDays <= 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.key_rotation_buffer_invalid, rotationBufferPath, new Object[]{1, this.getMaxRotationBufferDays(), this.rotationBufferName}));
            }
            if (keyPairValidator.getValidDays() >= 0 && rotationBufferDays >= keyPairValidator.getValidDays()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.key_rotation_buffer_too_large, rotationBufferPath, new Object[]{this.rotationBufferName}));
            }
        }
        return this.getErrors().isEmpty();
    }

    protected Integer getMaxRotationBufferDays() {
        int maxCertValidDays = MgmtFactory.getCertificateService().getMaxValidDays();
        return maxCertValidDays;
    }

    protected String getRotationBufferDaysStr() {
        return this.rotationBufferDaysStr;
    }

    protected String getValidDaysStr() {
        return this.validDaysStr;
    }

    protected String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    protected String getKeySizeStr() {
        return this.keySizeStr;
    }

    protected String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getRotationBufferPathName() {
        return null;
    }
}

