/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.LdapDataStorePaths;
import com.pingidentity.admin.api.model.fieldpaths.LdapTagPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;

public class LdapDefaultConnectionMismatchValidator
extends AbstractValidator {
    private List<LdapTagConfig> tagConfigList;
    private LdapInstanceIdentifier defaultInstance;

    public LdapDefaultConnectionMismatchValidator(List<LdapTagConfig> tagConfigList, LdapInstanceIdentifier defaultInstance) {
        this.tagConfigList = tagConfigList;
        this.defaultInstance = defaultInstance;
    }

    private void validateDefaultAndTagListDefaultMatch() {
        if (CollectionUtils.isNotEmpty(this.tagConfigList)) {
            for (LdapTagConfig tagConfig : this.tagConfigList) {
                if (!tagConfig.isDefaultSource() || Objects.equals(tagConfig.getIdentifier(), this.defaultInstance)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_mismatched_default_hostnames, LdapDataStorePaths.getHostnames()));
                break;
            }
        } else if (this.defaultInstance != null && StringUtils.isNotEmpty((String)this.defaultInstance.getHostname())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_missing_default_hostnames, LdapTagPaths.getTagArrayPath()));
        }
    }

    public boolean validate() {
        this.validateDefaultAndTagListDefaultMatch();
        return !this.hasErrors();
    }
}

