/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.LdapTagPaths;
import com.pingidentity.admin.api.validator.DataSourceTagConfigValidator;
import com.pingidentity.admin.api.validator.LdapHostnameValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;

public class LdapTagConfigValidator
extends DataSourceTagConfigValidator<LdapTagConfig> {
    public LdapTagConfigValidator(List<LdapTagConfig> tagConfigList, boolean useDnsSrvRecord, boolean useSsl) {
        super(tagConfigList, LdapTagPaths.getTagPath());
        if (tagConfigList != null) {
            int index = 0;
            for (LdapTagConfig tagConfig : tagConfigList) {
                String hostnames = null;
                if (tagConfig.getIdentifier() != null) {
                    hostnames = tagConfig.getIdentifier().getHostname();
                }
                this.addValidator((Validator)new LdapHostnameValidator(useDnsSrvRecord, useSsl, hostnames, LdapTagPaths.getHostnamesPath(index)));
                ++index;
            }
        }
    }

    @Override
    Set<String> hasDuplicateDataStoreIdentifier() {
        HashSet<String> existingHostnames = new HashSet<String>();
        HashSet<String> duplicateHostnames = new HashSet<String>();
        if (this.tagConfigList != null) {
            for (LdapTagConfig tagConfig : this.tagConfigList) {
                String tagConfigHostname = null;
                if (tagConfig.getIdentifier() != null) {
                    tagConfigHostname = tagConfig.getIdentifier().getHostname();
                }
                if (existingHostnames.contains(tagConfigHostname)) {
                    duplicateHostnames.add(tagConfigHostname);
                    continue;
                }
                existingHostnames.add(tagConfigHostname);
            }
        }
        return duplicateHostnames;
    }

    @Override
    void validateDefaultSet() {
        boolean hasFoundDefault = false;
        if (this.tagConfigList != null) {
            for (LdapTagConfig tagConfig : this.tagConfigList) {
                if (!tagConfig.isDefaultSource()) continue;
                if (!hasFoundDefault) {
                    hasFoundDefault = true;
                    continue;
                }
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_multiple_default_connection_urls, LdapTagPaths.getTagArrayPath()));
                break;
            }
        }
        if (!hasFoundDefault) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_missing_default_hostnames, LdapTagPaths.getTagArrayPath()));
        }
    }

    @Override
    public boolean validate() {
        Set<String> duplicateHostnames;
        super.validate();
        if (this.validateDuplicateDataStoreIdentifier && !(duplicateHostnames = this.hasDuplicateDataStoreIdentifier()).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_duplicate_hostnames, LdapTagPaths.getHostnamesPath(), new Object[]{"'" + StringUtils.join(duplicateHostnames, (String)"', '") + "'"}));
        }
        return !this.hasErrors();
    }

    @Override
    void appendMultipleEmptyTagError() {
        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_multiple_empty_tags, LdapTagPaths.getTagArrayPath()));
    }
}

