/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.GenericMappingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.LicenseObject;

public class LicenseConnectionGroupValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private LicenseObject licenseObject;
    private String requestedLicenseGroupName;

    public LicenseConnectionGroupValidator(LicenseObject licenseObject, String requestedLicenseGroupName) {
        this.licenseObject = licenseObject;
        this.requestedLicenseGroupName = requestedLicenseGroupName;
    }

    public boolean validate() {
        if (StringUtils.isEmpty((String)this.requestedLicenseGroupName)) {
            return true;
        }
        List<LicenseConnectionGroup> availableGroups = this.getAvailableLicenseConnectionGroups();
        if (!this.isConnectionGroupDefined()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.license_no_connection_groups_defined, GenericMappingsPaths.getLicenseConnectionGroupAssignment()));
        } else if (availableGroups.stream().noneMatch(licenseConnectionGroup -> licenseConnectionGroup.getGroupName().equals(this.requestedLicenseGroupName))) {
            this.appendError(this.errorFactory.create(ApiMessageKey.license_connection_group_invalid, GenericMappingsPaths.getLicenseConnectionGroupAssignment()));
        }
        return !this.hasErrors();
    }

    boolean isConnectionGroupDefined() {
        return LicenseManager.isConnectionGroupDefined();
    }

    List<LicenseConnectionGroup> getAvailableLicenseConnectionGroups() {
        return LicenseManager.getAvailableLicenseGroups((LicenseObject)this.licenseObject, (int)1);
    }
}

