/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;

public class ListNoNullEntriesValidator<T>
extends AbstractValidator {
    private List<T> list;
    private String fieldPath;

    public ListNoNullEntriesValidator(List<T> list, String fieldPath) {
        this.list = list;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (this.list == null) {
            return true;
        }
        int index = -1;
        for (T item : this.list) {
            ++index;
            if (item != null) continue;
            String itemPath = this.fieldPath + "[" + index + "]";
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, itemPath));
        }
        return !this.hasErrors();
    }
}

