/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeRule;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.LocalIdentityMappingPolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AbstractActionValidator;
import com.pingidentity.admin.api.validator.AuthnPolicyLipAttributeMappingValidator;
import com.pingidentity.admin.api.validator.FragmentPolicyOutputContractValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityMappingActionValidator
extends AbstractActionValidator {
    private final LocalIdentityManager localIdentityManager = MgmtFactory.getLocalIdentityProfileManager();
    private final boolean uniqueIdAttributeRequired;
    private final ValidatorContext context;

    public LocalIdentityMappingActionValidator(ActionValidatorInfo info, boolean uniqueIdAttributeRequired, ValidatorContext context) {
        super(info);
        LocalIdentityProfile localIdentityProfile;
        String lipId;
        this.uniqueIdAttributeRequired = uniqueIdAttributeRequired;
        this.context = context;
        if (info != null && info.getFragmentInfo() != null && (lipId = (String)Optional.ofNullable((LocalIdentityMappingPolicyAction)info.getAction()).map(LocalIdentityMappingPolicyAction::getLocalIdentityRef).map(ResourceLink::getId).orElse(null)) != null && (localIdentityProfile = this.localIdentityManager.getProfile(lipId)) != null) {
            String apcId = localIdentityProfile.getContractId();
            this.addValidator((Validator)new FragmentPolicyOutputContractValidator(this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationPolicyContractRefId()), CollectionUtils.isEmpty(this.validatorInfo.getChildren()), this.validatorInfo.getFragmentInfo(), apcId));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        ResourceLink lipResourceLink = ((LocalIdentityMappingPolicyAction)this.validatorInfo.getAction()).getLocalIdentityRef();
        if (lipResourceLink == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_incomplete_missing_local_identity_ref, this.makeFieldPath(AuthenticationPolicyActionPaths.getLocalIdentityRef())));
        } else {
            String lipId = lipResourceLink.getId();
            if (lipId == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.lip_id_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getLocalIdentityRefId())));
            } else {
                LocalIdentityProfile localIdentityProfile = this.getAndValidateLip(lipId);
                if (localIdentityProfile != null && !this.hasErrors()) {
                    AuthnPolicyLipAttributeMappingValidator validator = new AuthnPolicyLipAttributeMappingValidator((LocalIdentityMappingPolicyAction)this.validatorInfo.getAction(), localIdentityProfile, this.validatorInfo, this.uniqueIdAttributeRequired, this.context);
                    validator.validate();
                    this.appendErrors(validator.getErrors());
                }
            }
        }
        return !this.hasErrors();
    }

    private LocalIdentityProfile getAndValidateLip(String lipId) {
        LocalIdentityProfile localIdentityProfile = this.localIdentityManager.getProfile(lipId);
        if (localIdentityProfile == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.lip_id_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getLocalIdentityRefId())));
        }
        return localIdentityProfile;
    }

    @Override
    protected boolean isActionAllowed() {
        if (this.validatorInfo.getParentNodeAction() == null) {
            return false;
        }
        boolean hasAppropriateContext = false;
        AttributeRule theRuleBeingUsed = null;
        if (this.validatorInfo.getParentNodeAction() instanceof AuthnSourcePolicyAction && ((AuthnSourcePolicyAction)this.validatorInfo.getParentNodeAction()).getAttributeRules() != null) {
            List<AttributeRule> attributeRules = ((AuthnSourcePolicyAction)this.validatorInfo.getParentNodeAction()).getAttributeRules().getItems();
            theRuleBeingUsed = attributeRules.stream().filter(attributeRule -> attributeRule.getResult() != null && attributeRule.getResult().equals(this.validatorInfo.getAction().getContext())).findFirst().orElse(null);
        }
        if (this.validatorInfo.isFragmentPolicy() || this.validatorInfo.hasSuccessInPath() || this.isRegistrationBranch(theRuleBeingUsed)) {
            hasAppropriateContext = true;
        }
        return this.validatorInfo.hasAuthnSourceAncestor() && hasAppropriateContext;
    }

    private boolean isRegistrationBranch(AttributeRule attributeRule) {
        return attributeRule != null && attributeRule.getExpectedValue().equals("identity.registration") && attributeRule.getAttributeName().equals("policy.action");
    }

    @Override
    protected boolean needsChildren() {
        return false;
    }
}

