/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.LocalIdentityProfilePaths;
import com.pingidentity.admin.api.model.localidentity.BaseDefaultValueLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.CheckboxGroupLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.CheckboxLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.DataStoreAttribute;
import com.pingidentity.admin.api.model.localidentity.DataStoreConfig;
import com.pingidentity.admin.api.model.localidentity.DateLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.DropDownLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.EmailVerificationConfig;
import com.pingidentity.admin.api.model.localidentity.FieldConfig;
import com.pingidentity.admin.api.model.localidentity.HiddenLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityAuthSource;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityAuthSourceUpdatePolicy;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityFieldType;
import com.pingidentity.admin.api.model.localidentity.ProfileConfig;
import com.pingidentity.admin.api.model.localidentity.RegistrationConfig;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.ListNoNullEntriesValidator;
import com.pingidentity.admin.api.validator.ListNotEmptyValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.localidentity.DataStoreConfigValidator;
import com.pingidentity.admin.api.validator.localidentity.LocalIdentityProfileEmailVerificationTypeValidator;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.CheckboxField;
import com.pingidentity.localidentity.fieldtypes.CheckboxGroupField;
import com.pingidentity.localidentity.fieldtypes.DateField;
import com.pingidentity.localidentity.fieldtypes.DropDownField;
import com.pingidentity.localidentity.fieldtypes.EmailField;
import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.PhoneField;
import com.pingidentity.localidentity.fieldtypes.TextField;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class LocalIdentityProfileValidator
extends CompositeValidator {
    private static CheckboxField.CheckboxFieldConfig checkboxConfig = new CheckboxField.CheckboxFieldConfig();
    private static CheckboxGroupField.CheckboxGroupFieldConfig checkboxGroupFieldConfig = new CheckboxGroupField.CheckboxGroupFieldConfig();
    private static DateField.DateFieldConfig dateFieldConfig = new DateField.DateFieldConfig();
    private static DropDownField.DropDownConfig dropDownConfig = new DropDownField.DropDownConfig();
    private static EmailField.EmailFieldConfig emailFieldConfig = new EmailField.EmailFieldConfig();
    private static PhoneField.PhoneFieldConfig phoneFieldConfig = new PhoneField.PhoneFieldConfig();
    private static TextField.TextFieldConfig textFieldConfig = new TextField.TextFieldConfig();
    private static HiddenField.HiddenFieldConfig hiddenFieldConfig = new HiddenField.HiddenFieldConfig();
    private String id;
    private String name;
    private ResourceLink apcResourceLink;
    private List<LocalIdentityAuthSource> authSources = null;
    private LocalIdentityAuthSourceUpdatePolicy updatePolicy;
    private DataStoreConfig dataStoreConfig;
    private FieldConfig fieldConfig;
    private EmailVerificationConfig emailVerificationConfig;
    private boolean isRegistrationEnabled;
    private RegistrationConfig registrationConfig;
    private ProfileConfig profileConfig;
    private boolean isProfileEnabled;
    private boolean isCreate;
    private final Boolean isCreateSessionAfterRegistration;
    private ValidatorContext context;
    private static final LocalIdentityManager LIP_MANAGER = MgmtFactory.getLocalIdentityProfileManager();
    private static final C2cContractManager C_2_C_CONTRACT_MANAGER = MgmtFactory.getC2cContractManager();
    private static final PolicyFragmentManager FRAGMENT_MANAGER = MgmtFactory.getPolicyFragmentManager();

    private LocalIdentityProfileValidator(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.apcResourceLink = builder.apcResourceLink;
        this.authSources = builder.authSources;
        this.updatePolicy = builder.updatePolicy;
        this.dataStoreConfig = builder.dataStoreConfig;
        this.fieldConfig = builder.fieldConfig;
        this.emailVerificationConfig = builder.emailVerificationConfig;
        this.isRegistrationEnabled = builder.isRegistrationEnabled;
        this.registrationConfig = builder.registrationConfig;
        this.profileConfig = builder.profileConfig;
        this.isProfileEnabled = builder.isProfileEnabled;
        this.isCreate = builder.isCreate;
        this.isCreateSessionAfterRegistration = builder.isCreateSessionAfterRegistration;
        this.context = builder.context;
        this.addValidator((Validator)new NotBlankValidator(this.name, "Profile Name", LocalIdentityProfilePaths.getName()));
        this.addValidator((Validator)new ResourceIdValidator(this.apcResourceLink, "Apc reference", LocalIdentityProfilePaths.getApcReferencLinkPath()));
        if (this.isCreate) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, LocalIdentityProfilePaths.getId()));
        }
        if (this.authSources != null && !this.authSources.isEmpty()) {
            int i = 0;
            for (LocalIdentityAuthSource source : this.authSources) {
                this.addValidator((Validator)new IdValidator(source.getId(), true, false, 0, 33, LocalIdentityProfilePaths.getAuthSourcesId(i)));
                ++i;
            }
        }
        if (this.doValidateDataStoreConfig(this.isRegistrationEnabled, this.isProfileEnabled)) {
            if (this.dataStoreConfig != null) {
                List<String> availableVars = this.getContractToFulfill();
                Validator dataStoreConfigValidator = DataStoreConfigValidator.getInstance(this.dataStoreConfig, availableVars, this.isRegistrationEnabled, builder.context);
                if (dataStoreConfigValidator != null) {
                    this.addValidator(dataStoreConfigValidator);
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_config_required, LocalIdentityProfilePaths.getDataStoreConfig()));
            }
        }
        if (this.doValidateFieldConfig(this.isRegistrationEnabled, this.isProfileEnabled)) {
            this.validateEmptyFieldConfig();
        }
        if (this.doValidateRegistrationConfig(this.isRegistrationEnabled)) {
            this.validateEmptyRegistrationConfig();
            if (this.registrationConfig != null && this.registrationConfig.getRegistrationWorkflow() != null) {
                this.addValidator((Validator)new ResourceIdValidator(this.registrationConfig.getRegistrationWorkflow(), "Registration Workflow reference", LocalIdentityProfilePaths.getRegistrationConfigRegistrationWorkflowReferencLinkPath()));
            }
        }
        if (this.doValidateProfileConfig(this.isProfileEnabled)) {
            this.validateEmptyProfileConfig();
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            this.validateDuplicateProfileNameAndId();
            this.validateApc();
            if (this.authSources != null) {
                this.validateAuthSources(this.authSources);
            }
            if (this.updatePolicy != null) {
                this.validateUpdatePolicy(this.updatePolicy, this.authSources);
            }
            if (this.fieldConfig != null) {
                this.validateFields(this.fieldConfig.getFields());
            }
            if (this.emailVerificationConfig != null) {
                this.validateEmailVerificationConfig();
            }
            if (this.dataStoreConfig != null) {
                this.validateDataStoreConfig();
            }
            if (this.registrationConfig != null) {
                this.validateRegistrationConfig();
            }
            if (this.profileConfig != null) {
                this.validateProfileConfig();
            }
        }
        return !this.hasErrors();
    }

    private boolean doValidateEmailVerificationConfig(boolean isRegistrationEnabled, boolean isProfileEnabled) {
        return (isRegistrationEnabled || isProfileEnabled) && this.emailVerificationConfig != null && this.emailVerificationConfig.isEmailVerificationEnabled();
    }

    private void validateFields(List<LocalIdentityField> fields) {
        if (!this.isRegistrationEnabled && !this.isProfileEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_invalid, LocalIdentityProfilePaths.getFieldConfig()));
            return;
        }
        this.validateUniqueFieldEntries(fields);
        this.validateUniqueIdFields(fields);
        int index = 0;
        for (LocalIdentityField field : fields) {
            switch (field.getType()) {
                case DROP_DOWN: {
                    this.validateDropDownField((DropDownLocalIdentityField)field, index);
                    break;
                }
                case CHECKBOX_GROUP: {
                    this.validateCheckBoxGroupField((CheckboxGroupLocalIdentityField)field, index);
                    break;
                }
                case CHECKBOX: {
                    this.validateCheckBoxField((CheckboxLocalIdentityField)field, index);
                    break;
                }
                case DATE: {
                    this.validateDateField((DateLocalIdentityField)field, index);
                    break;
                }
            }
            this.validateFieldAttributes(field, index);
            this.validateProfileRegistrationEnabled(field, index);
            if (this.isValidateDefaultValue(field)) {
                this.validateDefaultValue(field, index);
            }
            ++index;
        }
    }

    private void validateDefaultValue(LocalIdentityField field, int index) {
        String defaultValue = null;
        if (field instanceof BaseDefaultValueLocalIdentityField) {
            defaultValue = ((BaseDefaultValueLocalIdentityField)field).getDefaultValue();
        } else if (field instanceof DropDownLocalIdentityField) {
            defaultValue = ((DropDownLocalIdentityField)field).getDefaultValue();
        }
        if (StringUtils.isNotBlank((String)defaultValue) && this.isReadOnly(field)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_default_and_read_only, LocalIdentityProfilePaths.getFieldsItems(index)));
        }
    }

    private boolean isValidateDefaultValue(LocalIdentityField field) {
        return field instanceof BaseDefaultValueLocalIdentityField || field instanceof DropDownLocalIdentityField;
    }

    private void validateDateField(DateLocalIdentityField field, int index) {
        if (StringUtils.isNotBlank((String)field.getDefaultValue())) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate.parse(field.getDefaultValue(), formatter);
            }
            catch (DateTimeParseException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_date_default_value_invalid, LocalIdentityProfilePaths.getFieldsItems(index)));
            }
        }
    }

    private void validateProfileRegistrationEnabled(LocalIdentityField field, int index) {
        if (this.isProfileEnabled && this.isRegistrationEnabled && !field.isProfilePageField() && !field.isRegistrationPageField() && !(field instanceof HiddenLocalIdentityField)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_profile_or_registration_page_enabled_required, LocalIdentityProfilePaths.getFieldsItems(index)));
        }
        if (this.isProfileEnabled && !this.isRegistrationEnabled) {
            if (!field.isProfilePageField()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_profile_page_enabled_required, LocalIdentityProfilePaths.getProfilePageField(index)));
            }
            if (field.isRegistrationPageField()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_registration_page_enabled_invalid, LocalIdentityProfilePaths.getRegistrationPageField(index)));
            }
        }
        if (this.isRegistrationEnabled && !this.isProfileEnabled) {
            if (!field.isRegistrationPageField()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_registration_page_enabled_required, LocalIdentityProfilePaths.getRegistrationPageField(index)));
            }
            if (field.isProfilePageField()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_profile_page_enabled_invalid, LocalIdentityProfilePaths.getProfilePageField(index)));
            }
        }
    }

    private void validateCheckBoxGroupField(CheckboxGroupLocalIdentityField checkboxGroupLocalIdentityField, int index) {
        if (checkboxGroupLocalIdentityField.getOptions() == null || checkboxGroupLocalIdentityField.getOptions().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_checkbox_group_options_required, LocalIdentityProfilePaths.getFieldsItems(index)));
        } else if (checkboxGroupLocalIdentityField.getOptions().contains(null) || checkboxGroupLocalIdentityField.getOptions().contains("")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_options_invalid, LocalIdentityProfilePaths.getFieldsItems(index)));
        } else {
            UniqueEntriesValidator.UniqueKeyGetter<String> optionsUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

                @Override
                public String getKey(String object) {
                    if (object != null) {
                        return object;
                    }
                    return null;
                }
            };
            UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(optionsUniqueKeyGetter, checkboxGroupLocalIdentityField.getOptions(), LocalIdentityProfilePaths.getFieldsItems(index), ApiMessageKey.local_identity_profile_field_config_options_invalid);
            uniqueEntriesValidator.validate();
            this.appendErrors(uniqueEntriesValidator.getErrors());
        }
    }

    private void validateCheckBoxField(CheckboxLocalIdentityField field, int index) {
        if (StringUtils.isNotBlank((String)field.getDefaultValue()) && !field.getDefaultValue().equalsIgnoreCase(Boolean.TRUE.toString()) && !field.getDefaultValue().equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_checkbox_default_value_invalid, LocalIdentityProfilePaths.getFieldsItems(index)));
        }
    }

    private void validateFieldAttributes(LocalIdentityField localIdentityField, int index) {
        boolean required;
        if (localIdentityField.getAttributes() == null) {
            return;
        }
        boolean incorrectAttributes = false;
        switch (localIdentityField.getType()) {
            case CHECKBOX: {
                if (checkboxConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case CHECKBOX_GROUP: {
                if (checkboxGroupFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case DATE: {
                if (dateFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case DROP_DOWN: {
                if (dropDownConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case EMAIL: {
                if (emailFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case PHONE: {
                if (phoneFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case TEXT: {
                if (textFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
            case HIDDEN: {
                if (hiddenFieldConfig.getAttributes().containsAll(localIdentityField.getAttributes().keySet())) break;
                incorrectAttributes = true;
                break;
            }
        }
        if (incorrectAttributes) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_incorrect_attributes, LocalIdentityProfilePaths.getFieldAttributes(index)));
        }
        if ((required = localIdentityField.getAttributes().getOrDefault("Required", false).booleanValue()) && this.isReadOnly(localIdentityField)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_read_only_and_required, LocalIdentityProfilePaths.getFieldAttributes(index)));
        }
    }

    private boolean isReadOnly(LocalIdentityField localIdentityField) {
        return localIdentityField.getAttributes().getOrDefault("Read-Only", false);
    }

    private void validateDropDownField(DropDownLocalIdentityField dropDownLocalIdentityField, int index) {
        if (dropDownLocalIdentityField.getOptions() == null || dropDownLocalIdentityField.getOptions().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_drop_down_options_required, LocalIdentityProfilePaths.getFieldsItems(index)));
        } else if (dropDownLocalIdentityField.getOptions().contains(null) || dropDownLocalIdentityField.getOptions().contains("")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_options_invalid, LocalIdentityProfilePaths.getFieldsItems(index)));
        } else {
            UniqueEntriesValidator.UniqueKeyGetter<String> optionsUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

                @Override
                public String getKey(String object) {
                    if (object != null) {
                        return object;
                    }
                    return null;
                }
            };
            UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(optionsUniqueKeyGetter, dropDownLocalIdentityField.getOptions(), LocalIdentityProfilePaths.getFieldsItems(index), ApiMessageKey.local_identity_profile_field_config_options_invalid);
            uniqueEntriesValidator.validate();
            this.appendErrors(uniqueEntriesValidator.getErrors());
            if (StringUtils.isNotBlank((String)dropDownLocalIdentityField.getDefaultValue()) && !dropDownLocalIdentityField.getOptions().contains(dropDownLocalIdentityField.getDefaultValue())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_drop_down_default_value_invalid, LocalIdentityProfilePaths.getFieldsItems(index)));
            }
        }
    }

    private void validateUniqueIdFields(List<LocalIdentityField> fields) {
        boolean uniqueFieldAvailableForRegistration;
        List uniqueFields = fields.stream().filter(field -> field.getAttributes() != null && field.getAttributes().get("Unique ID Field") != null && field.getAttributes().get("Unique ID Field") != false).collect(Collectors.toList());
        if (uniqueFields.size() == 0) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_unique_field_required, LocalIdentityProfilePaths.getFieldConfig()));
        }
        if (uniqueFields.size() > 1) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_only_one_unique_field_allowed, LocalIdentityProfilePaths.getFieldConfig()));
        }
        if (this.isRegistrationEnabled && !(uniqueFieldAvailableForRegistration = uniqueFields.stream().anyMatch(field -> field.isRegistrationPageField()))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_only_one_unique_field_required_registration, LocalIdentityProfilePaths.getFieldConfig()));
        }
    }

    private void validateEmptyFieldConfig() {
        if (this.fieldConfig == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_required, LocalIdentityProfilePaths.getFieldConfig()));
        } else {
            this.addValidator((Validator)new ListNotEmptyValidator(this.fieldConfig.getFields(), ApiMessageKey.local_identity_profile_field_config_field_required, LocalIdentityProfilePaths.getFields()));
            if (this.fieldConfig.getFields() != null) {
                this.addValidator((Validator)new ListNoNullEntriesValidator<LocalIdentityField>(this.fieldConfig.getFields(), LocalIdentityProfilePaths.getFields()));
                int index = 0;
                for (LocalIdentityField localIdentityField : this.fieldConfig.getFields()) {
                    this.validateLocalIdentityFieldType(localIdentityField.getType(), index);
                    this.addValidator((Validator)new NotBlankValidator(localIdentityField.getId(), "'id'", LocalIdentityProfilePaths.getFieldsItems(index)));
                    this.addValidator((Validator)new NotBlankValidator(localIdentityField.getLabel(), "'label'", LocalIdentityProfilePaths.getFieldsItems(index)));
                    ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
                    if (localIdentityField.getId() != null && !CommonValidator.isValidAdapterInstanceId((String)localIdentityField.getId())) {
                        this.appendError(errorFactory.create(ApiMessageKey.local_identity_profile_field_id_invalid, LocalIdentityProfilePaths.getFieldItemId(index), new Object[]{33}));
                    }
                    ++index;
                }
            }
        }
    }

    private void validateApc() {
        if (C_2_C_CONTRACT_MANAGER.getContract(this.apcResourceLink.getId()) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_apc_invalid, LocalIdentityProfilePaths.getApcId()));
        }
    }

    private void validateDuplicateProfileNameAndId() {
        for (LocalIdentityProfile existingProfile : LIP_MANAGER.getProfiles()) {
            if (existingProfile.getName().equalsIgnoreCase(this.name) && !StringUtils.equals((String)existingProfile.getId(), (String)this.id)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_name_exists, LocalIdentityProfilePaths.getName()));
            }
            if (!this.isCreate || !existingProfile.getId().equals(this.id)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_id_exists, LocalIdentityProfilePaths.getId()));
        }
    }

    void validateUpdatePolicy(LocalIdentityAuthSourceUpdatePolicy updatePolicy, List<LocalIdentityAuthSource> authSources) {
        if (updatePolicy.isStoreAttributes() && !this.isRegistrationEnabled && !this.isProfileEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_attribute_storage_enabled_no_profile_or_registration, LocalIdentityProfilePaths.getUpdatePolicy()));
            return;
        }
        if (updatePolicy.isStoreAttributes() && (authSources == null || authSources.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_attribute_storage_enabled_no_auth_sources, LocalIdentityProfilePaths.getUpdatePolicy()));
        }
        if (updatePolicy.isRetainAttributes() && !updatePolicy.isStoreAttributes()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_retain_enabled_without_storage, LocalIdentityProfilePaths.getUpdatePolicy()));
        }
        if (updatePolicy.isUpdateAttributes()) {
            if (!updatePolicy.isStoreAttributes()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_update_enabled_without_storage, LocalIdentityProfilePaths.getUpdatePolicy()));
            }
            if (updatePolicy.getUpdateInterval() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_update_interval_required, LocalIdentityProfilePaths.getUpdatePolicy()));
            }
            if (updatePolicy.getUpdateInterval() != null && (updatePolicy.getUpdateInterval() < 0.0 || updatePolicy.getUpdateInterval() > 99999.0)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_update_interval_invalid, LocalIdentityProfilePaths.getUpdatePolicy()));
            }
        }
    }

    private void validateAuthSources(List<LocalIdentityAuthSource> authSources) {
        UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityAuthSource> localIdentityAuthSourceUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityAuthSource>(){

            @Override
            public String getKey(LocalIdentityAuthSource object) {
                return object.getSource();
            }
        };
        UniqueEntriesValidator<LocalIdentityAuthSource> uniqueEntriesValidator = new UniqueEntriesValidator<LocalIdentityAuthSource>(localIdentityAuthSourceUniqueKeyGetter, authSources, LocalIdentityProfilePaths.getAuthSources(), ApiMessageKey.local_identity_profile_auth_sources_source_duplicate);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
        UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityAuthSource> localIdentityAuthSourceIDUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityAuthSource>(){

            @Override
            public String getKey(LocalIdentityAuthSource object) {
                return object.getId();
            }
        };
        UniqueEntriesValidator<LocalIdentityAuthSource> uniqueIDEntriesValidator = new UniqueEntriesValidator<LocalIdentityAuthSource>(localIdentityAuthSourceIDUniqueKeyGetter, authSources, LocalIdentityProfilePaths.getAuthSources(), ApiMessageKey.local_identity_profile_auth_sources_id_duplicate);
        uniqueIDEntriesValidator.setIgnoreNullEntries(true);
        uniqueIDEntriesValidator.validate();
        this.appendErrors(uniqueIDEntriesValidator.getErrors());
    }

    private void validateUniqueFieldEntries(List<LocalIdentityField> fields) {
        UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityField> fieldsUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<LocalIdentityField>(){

            @Override
            public String getKey(LocalIdentityField object) {
                if (object.getId() != null) {
                    return object.getId();
                }
                return null;
            }
        };
        UniqueEntriesValidator<LocalIdentityField> uniqueEntriesValidator = new UniqueEntriesValidator<LocalIdentityField>(fieldsUniqueKeyGetter, fields, LocalIdentityProfilePaths.getFields(), ApiMessageKey.local_identity_profile_field_config_fields_duplicate, ApiMessageKey.local_identity_profile_field_config_field_required);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private void validateUniqueDsAttributeNames(List<String> dsAttributeNames) {
        UniqueEntriesValidator.UniqueKeyGetter<String> attrNamesUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                if (object != null) {
                    return object;
                }
                return null;
            }
        };
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(attrNamesUniqueKeyGetter, dsAttributeNames, LocalIdentityProfilePaths.getDataStoreMapping(), ApiMessageKey.local_identity_profile_data_store_mapping_duplicate_names, ApiMessageKey.local_identity_profile_data_store_mapping_name_required);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private void validateUniqueDsMappingKeys(List<String> fieldKeys) {
        UniqueEntriesValidator.UniqueKeyGetter<String> dsMappingKeysUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                if (object != null) {
                    return object;
                }
                return null;
            }
        };
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(dsMappingKeysUniqueKeyGetter, fieldKeys, LocalIdentityProfilePaths.getDataStoreMapping(), ApiMessageKey.local_identity_profile_data_store_mapping_duplicate_keys, ApiMessageKey.local_identity_profile_data_store_mapping_key_required);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private void validateLocalIdentityFieldType(LocalIdentityFieldType localIdentityFieldType, int index) {
        if (localIdentityFieldType == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_field_type_required, LocalIdentityProfilePaths.getFieldsItems(index)));
        }
    }

    void validateEmailVerificationConfig() {
        if (!this.isRegistrationEnabled && !this.isProfileEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_verify_email_verification_config_invalid, LocalIdentityProfilePaths.getEmailVerificationConfig()));
            return;
        }
        LocalIdentityProfileEmailVerificationTypeValidator.Builder emailVerificationTypeBuilder = new LocalIdentityProfileEmailVerificationTypeValidator.Builder();
        emailVerificationTypeBuilder.setAdminApiValidation(true).setEmailVerificationEnabled(this.emailVerificationConfig.isEmailVerificationEnabled()).setEmailVerificationType(this.emailVerificationConfig.getEmailVerificationType()).setOtpLength(this.emailVerificationConfig.getOtpLength() != null ? this.emailVerificationConfig.getOtpLength().toString() : null).setAllowedOtpCharacterSet(this.emailVerificationConfig.getAllowedOtpCharacterSet()).setOtpRetryAttempts(this.emailVerificationConfig.getOtpRetryAttempts() != null ? this.emailVerificationConfig.getOtpRetryAttempts().toString() : null).setOtpTimeToLive(this.emailVerificationConfig.getOtpTimeToLive() != null ? this.emailVerificationConfig.getOtpTimeToLive().toString() : null).setEmailVerificationOtpTemplateName(this.emailVerificationConfig.getEmailVerificationOtpTemplateName()).setOtlTimeToLive(this.emailVerificationConfig.getOtlTimeToLive() != null ? this.emailVerificationConfig.getOtlTimeToLive().toString() : null).setRequireEmailVerificationTemplateName(this.emailVerificationConfig.getRequireVerifiedEmailTemplateName()).setEmailVerificationSentTemplateName(this.emailVerificationConfig.getEmailVerificationSentTemplateName());
        LocalIdentityProfileEmailVerificationTypeValidator emailVerificationTypeValidator = emailVerificationTypeBuilder.build();
        if (!emailVerificationTypeValidator.validate()) {
            this.appendErrors(emailVerificationTypeValidator.getErrors());
        }
        if (!this.emailVerificationConfig.isEmailVerificationEnabled()) {
            boolean anyErrors = false;
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getVerifyEmailTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_verify_email_template_not_allowed, LocalIdentityProfilePaths.getVerifyEmailTemplate()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getEmailVerificationSentTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_sent_template_not_allowed, LocalIdentityProfilePaths.getEmailVerificationSentTemplate()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getEmailVerificationSuccessTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_success_template_not_allowed, LocalIdentityProfilePaths.getEmailVerificationSuccessTemplate()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getEmailVerificationErrorTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_error_template_not_allowed, LocalIdentityProfilePaths.getEmailVerificationErrorTemplate()));
                anyErrors = true;
            }
            if (this.emailVerificationConfig.getOtlTimeToLive() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otl_time_to_live_not_allowed, LocalIdentityProfilePaths.getOtlTimeToLive()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getFieldForEmailToVerify())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_used_for_ownership_verification_not_allowed, LocalIdentityProfilePaths.getEmailVerificationFieldForEmailToVerify()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getFieldStoringVerificationStatus())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_storing_verification_status_not_allowed, LocalIdentityProfilePaths.getEmailVerificationFieldStoringVerificationStatus()));
                anyErrors = true;
            }
            if (this.emailVerificationConfig.getNotificationPublisherRef() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_notification_publisher_not_allowed, LocalIdentityProfilePaths.getEmailVerificationNotificationPublisherRef()));
                anyErrors = true;
            }
            if (Boolean.TRUE.equals(this.emailVerificationConfig.isRequireVerifiedEmail())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_require_verified_email_invalid, LocalIdentityProfilePaths.getRequireVerifiedEmail()));
                anyErrors = true;
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationConfig.getRequireVerifiedEmailTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_require_verified_email_template_not_allowed, LocalIdentityProfilePaths.getRequireVerifiedEmailTemplate()));
                anyErrors = true;
            }
            if (anyErrors) {
                return;
            }
        } else {
            LocalSettings localSettings;
            if (this.emailVerificationConfig.getFieldForEmailToVerify() == null || this.emailVerificationConfig.getFieldForEmailToVerify().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_used_for_ownership_verification_required, LocalIdentityProfilePaths.getEmailVerificationFieldForEmailToVerify()));
            } else {
                for (LocalIdentityField field : this.fieldConfig.getFields()) {
                    if (!this.emailVerificationConfig.getFieldForEmailToVerify().equals(field.getId()) || field.getType().equals((Object)LocalIdentityFieldType.EMAIL) || field.getType().equals((Object)LocalIdentityFieldType.TEXT)) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_used_for_ownership_verification_invalid, LocalIdentityProfilePaths.getEmailVerificationFieldForEmailToVerify()));
                }
            }
            if (this.emailVerificationConfig.getFieldStoringVerificationStatus() == null || this.emailVerificationConfig.getFieldStoringVerificationStatus().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_storing_verification_status_required, LocalIdentityProfilePaths.getEmailVerificationFieldStoringVerificationStatus()));
            } else {
                for (LocalIdentityField field : this.fieldConfig.getFields()) {
                    if (!this.emailVerificationConfig.getFieldStoringVerificationStatus().equals(field.getId()) || field.getType().equals((Object)LocalIdentityFieldType.HIDDEN)) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_storing_verification_status_invalid, LocalIdentityProfilePaths.getEmailVerificationFieldStoringVerificationStatus()));
                }
            }
            List fieldNamesInFieldConfig = this.fieldConfig.getFields().parallelStream().map(LocalIdentityField::getId).collect(Collectors.toList());
            if (!fieldNamesInFieldConfig.contains(this.emailVerificationConfig.getFieldForEmailToVerify())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_used_for_ownership_verification_invalid, LocalIdentityProfilePaths.getEmailVerificationFieldForEmailToVerify()));
            }
            if (!fieldNamesInFieldConfig.contains(this.emailVerificationConfig.getFieldStoringVerificationStatus())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_field_storing_verification_status_invalid, LocalIdentityProfilePaths.getEmailVerificationFieldStoringVerificationStatus()));
            }
            if (!(localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings()).isEnableSP()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_roles_and_protocols_required, LocalIdentityProfilePaths.getEmailVerificationConfigEmailVerificationEnabled()));
            }
            boolean isNotificationPublisherPresent = false;
            if (this.emailVerificationConfig.getNotificationPublisherRef() != null) {
                String notificationPublisherId = this.emailVerificationConfig.getNotificationPublisherRef().getId();
                if (StringUtils.isBlank((String)notificationPublisherId)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_id_missing, LocalIdentityProfilePaths.getEmailVerificationNotificationPublisherRef()));
                } else {
                    NotificationPublisherPluginManager pluginMgr = MgmtFactory.getNotificationPublisherPluginManager();
                    NotificationSenderPluginInstance instance = (NotificationSenderPluginInstance)pluginMgr.getInstance(notificationPublisherId);
                    if (instance == null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_not_found, LocalIdentityProfilePaths.getEmailVerificationNotificationPublisherRef(), new Object[]{notificationPublisherId}));
                    } else {
                        isNotificationPublisherPresent = true;
                    }
                }
            }
            NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            if (!isNotificationPublisherPresent && notificationSenderPluginInstance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_email_server_settings_required, LocalIdentityProfilePaths.getEmailVerificationConfigEmailVerificationEnabled()));
            }
            if (!Boolean.TRUE.equals(this.emailVerificationConfig.isRequireVerifiedEmail()) && StringUtils.isNotBlank((String)this.emailVerificationConfig.getRequireVerifiedEmailTemplateName())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_require_verified_email_template_not_allowed, LocalIdentityProfilePaths.getRequireVerifiedEmailTemplate()));
            }
        }
    }

    private void validateDataStoreConfig() {
        if (!this.isRegistrationEnabled && !this.isProfileEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_config_invalid, LocalIdentityProfilePaths.getDataStoreConfig()));
            return;
        }
        Map<String, DataStoreAttribute> dataStoreAttributeMap = this.dataStoreConfig.getDataStoreMapping();
        ArrayList<String> fieldKeys = new ArrayList<String>();
        ArrayList<String> dsAttributeNames = new ArrayList<String>();
        for (Map.Entry<String, DataStoreAttribute> entry : dataStoreAttributeMap.entrySet()) {
            fieldKeys.add(entry.getKey());
            dsAttributeNames.add(entry.getValue().getName());
        }
        List<LocalIdentityField> localIdentityFields = this.fieldConfig.getFields();
        List fieldNamesInFieldConfig = localIdentityFields.parallelStream().map(LocalIdentityField::getId).collect(Collectors.toList());
        int dsMappingKeyIndex = 0;
        for (String fieldKey : fieldKeys) {
            if (!fieldNamesInFieldConfig.contains(fieldKey)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_mapping_key_invalid, LocalIdentityProfilePaths.getDataStoreMapping(dsMappingKeyIndex), new Object[]{fieldKey}));
            }
            ++dsMappingKeyIndex;
        }
        int fieldIdIndex = 0;
        for (String fieldId : fieldNamesInFieldConfig) {
            if (!fieldKeys.contains(fieldId)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_field_config_field_missing_mapping, LocalIdentityProfilePaths.getFieldsItems(fieldIdIndex), new Object[]{fieldId}));
            }
            ++fieldIdIndex;
        }
        this.validateUniqueDsMappingKeys(fieldKeys);
        this.validateUniqueDsAttributeNames(dsAttributeNames);
    }

    private void validateEmptyRegistrationConfig() {
        if (this.registrationConfig == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_registration_config_required, LocalIdentityProfilePaths.getRegistrationConfig()));
        }
    }

    void validateRegistrationConfig() {
        if (!this.isRegistrationEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_registration_config_invalid, LocalIdentityProfilePaths.getRegistrationConfig()));
            return;
        }
        if (this.registrationConfig.isCaptchaEnabled()) {
            boolean isCaptchaProviderPresent = false;
            if (this.registrationConfig.getCaptchaProviderRef() != null) {
                String captchaProviderId = this.registrationConfig.getCaptchaProviderRef().getId();
                if (StringUtils.isBlank((String)captchaProviderId)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_provider_id_missing, LocalIdentityProfilePaths.getCaptchaProviderRef()));
                } else {
                    CaptchaProviderInstance instance = (CaptchaProviderInstance)MgmtFactory.getCaptchaProviderPluginManager().getInstance(captchaProviderId);
                    if (instance == null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_provider_not_found, LocalIdentityProfilePaths.getCaptchaProviderRef(), new Object[]{captchaProviderId}));
                    } else {
                        isCaptchaProviderPresent = true;
                    }
                }
            }
            CaptchaProviderInstance defaultCaptchaProvider = (CaptchaProviderInstance)MgmtFactory.getCaptchaProviderPluginManager().getDefaultInstance();
            if (!isCaptchaProviderPresent && defaultCaptchaProvider == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_registration_config_captcha_provider_required, LocalIdentityProfilePaths.getCaptchaEnabled()));
            }
        }
        if (this.registrationConfig.getTemplateName() == null || this.registrationConfig.getTemplateName().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_registration_config_template_name_required, LocalIdentityProfilePaths.getRegistrationConfigTemplateName()));
        }
        if (this.registrationConfig.isCreateAuthnSessionAfterRegistration()) {
            this.validateUsernameField();
        } else if (StringUtils.isNotBlank((String)this.registrationConfig.getUsernameField())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_session_username_field_not_required, LocalIdentityProfilePaths.getSessionUsernameAfterRegistration()));
        }
        if (this.registrationConfig.getRegistrationWorkflow() != null && FRAGMENT_MANAGER.getFragment(this.registrationConfig.getRegistrationWorkflow().getId()) == null && !this.context.isBulkConfigRequest()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_registration_config_registration_workflow_invalid, LocalIdentityProfilePaths.getRegistrationConfigRegistrationWorkflow()));
        }
    }

    private void validateUsernameField() {
        List matchingFields;
        if (StringUtils.isNotBlank((String)this.registrationConfig.getUsernameField()) && (matchingFields = this.fieldConfig.getFields().stream().filter(field -> field.getId().equals(this.registrationConfig.getUsernameField())).collect(Collectors.toList())).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_session_username_field_not_found, LocalIdentityProfilePaths.getSessionUsernameAfterRegistration()));
        }
    }

    private void validateProfileConfig() {
        if (!this.isProfileEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_management_config_invalid, LocalIdentityProfilePaths.getProfileConfig()));
            return;
        }
        if (this.profileConfig.getTemplateName() == null || this.profileConfig.getTemplateName().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_profile_config_template_name_required, LocalIdentityProfilePaths.getProfileConfigTemplateName()));
        }
    }

    private void validateEmptyProfileConfig() {
        if (this.profileConfig == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_management_config_required, LocalIdentityProfilePaths.getProfileConfig()));
        }
    }

    private List<String> getContractToFulfill() {
        if (this.fieldConfig != null && this.fieldConfig.getFields() != null) {
            return this.fieldConfig.getFields().stream().map(LocalIdentityField::getId).collect(Collectors.toList());
        }
        return null;
    }

    private boolean doValidateFieldConfig(boolean isRegistrationEnabled, boolean isProfileEnabled) {
        return isRegistrationEnabled || isProfileEnabled;
    }

    private boolean doValidateDataStoreConfig(boolean isRegistrationEnabled, boolean isProfileEnabled) {
        return isRegistrationEnabled || isProfileEnabled;
    }

    private boolean doValidateRegistrationConfig(boolean isRegistrationEnabled) {
        return isRegistrationEnabled;
    }

    private boolean doValidateProfileConfig(boolean isProfileEnabled) {
        return isProfileEnabled;
    }

    public static class Builder {
        private String id;
        private String name;
        private ResourceLink apcResourceLink;
        private List<LocalIdentityAuthSource> authSources = null;
        private LocalIdentityAuthSourceUpdatePolicy updatePolicy;
        private DataStoreConfig dataStoreConfig;
        private FieldConfig fieldConfig;
        private EmailVerificationConfig emailVerificationConfig;
        private boolean isRegistrationEnabled;
        private RegistrationConfig registrationConfig;
        private ProfileConfig profileConfig;
        private boolean isProfileEnabled;
        private boolean isCreate;
        private Boolean isCreateSessionAfterRegistration;
        private ValidatorContext context;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setApcResourceLink(ResourceLink apcResourceLink) {
            this.apcResourceLink = apcResourceLink;
            return this;
        }

        public Builder setAuthSources(List<LocalIdentityAuthSource> authSources) {
            this.authSources = authSources;
            return this;
        }

        public Builder setAuthSourceUpdatePolicy(LocalIdentityAuthSourceUpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        public Builder setDataStoreConfig(DataStoreConfig dataStoreConfig) {
            this.dataStoreConfig = dataStoreConfig;
            return this;
        }

        public Builder setFieldConfig(FieldConfig fieldConfig) {
            this.fieldConfig = fieldConfig;
            return this;
        }

        public Builder setEmailVerificationConfig(EmailVerificationConfig emailVerificationConfig) {
            this.emailVerificationConfig = emailVerificationConfig;
            return this;
        }

        public Builder setRegistrationEnabled(boolean isRegistrationEnabled) {
            this.isRegistrationEnabled = isRegistrationEnabled;
            return this;
        }

        public Builder setRegistrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public Builder setProfileConfig(ProfileConfig profileConfig) {
            this.profileConfig = profileConfig;
            return this;
        }

        public Builder setProfileEnabled(boolean isProfileEnabled) {
            this.isProfileEnabled = isProfileEnabled;
            return this;
        }

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setContext(ValidatorContext context) {
            this.context = context;
            return this;
        }

        public Builder setCreateSessionAfterRegistration(Boolean isCreateSessionAfterRegistration) {
            this.isCreateSessionAfterRegistration = isCreateSessionAfterRegistration;
            return this;
        }

        public LocalIdentityProfileValidator build() {
            return new LocalIdentityProfileValidator(this);
        }
    }
}

