/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.VerificationException;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.util.DsigUtil;

public class MetadataSignatureValidator
extends AbstractValidator {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final XmlSignatureVerifier verifier;
    private final boolean errorOnNoCert;
    private final String metadataFieldPath;
    private final String verificationCertFieldPath;

    public MetadataSignatureValidator(XmlObject metadataXml, boolean errorOnNoCert, Cert verificationCert, String metadataFieldPath, String verificationCertPath) {
        XmlSignatureVerifier tempVerifier;
        this.errorOnNoCert = errorOnNoCert;
        this.metadataFieldPath = metadataFieldPath;
        this.verificationCertFieldPath = verificationCertPath;
        this.verifier = tempVerifier = this.getVerifier(metadataXml, verificationCert);
    }

    private XmlSignatureVerifier getVerifier(XmlObject metadataXml, Cert verificationCert) {
        XmlSignatureVerifier tempVerifier;
        try {
            tempVerifier = DsigUtil.createVerifier((XmlObject)metadataXml);
            if (verificationCert != null) {
                tempVerifier.setProvidedX509Cert(verificationCert.getX509Certificate());
            }
        }
        catch (VerificationException e) {
            this.log.debug((Object)"Unable to create an xml signature verifier", (Throwable)e);
            tempVerifier = null;
        }
        return tempVerifier;
    }

    public boolean validate() {
        String effectiveCertFieldPath;
        if (this.verifier == null) {
            this.log.debug((Object)"Metadata signature validation failed. Unable to create a signature verifier. This is typically caused by invalid metadata.");
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_invalid, this.metadataFieldPath));
            return false;
        }
        String string = effectiveCertFieldPath = this.verifier.isCertInKeyInfo() ? this.metadataFieldPath : this.verificationCertFieldPath;
        if (this.verifier.hasSignature()) {
            if (this.verifier.hasCert()) {
                if (this.verifier.isCertKnownToBeRevoked()) {
                    this.log.debug((Object)"Metadata signature validation failed, certificate to be used for metadata signature validation is known to be revoked.");
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_certificate_revoked, effectiveCertFieldPath));
                    return false;
                }
                if (this.verifier.getSignatureStatus() != SignatureStatus.VALID) {
                    this.log.debug((Object)("Metadata signature validation failed. Signature Status: '" + this.verifier.getSignatureResult().getStatus() + "' Failure Reason(s):" + this.verifier.getSignatureResult().getCommentary()));
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_certificate_does_not_match_sig, effectiveCertFieldPath));
                    return false;
                }
                X509Certificate cert = this.verifier.getEffectiveCert();
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    this.log.debug((Object)"Metadata signature validation failed, the signing certificate has expired");
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_certificate_expired, effectiveCertFieldPath));
                    return false;
                }
                catch (CertificateNotYetValidException e) {
                    this.log.debug((Object)"Metadata signature validation failed, the signing certificate is not valid yet");
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_certificate_not_yet_valid, effectiveCertFieldPath));
                    return false;
                }
                return true;
            }
            if (this.errorOnNoCert) {
                this.log.debug((Object)"Metadata signature validation failed, a validation certificate is not available");
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_certificate_required, this.verificationCertFieldPath));
                return false;
            }
            this.log.debug((Object)"Metadata is signed but a validation certificate is not available. Signature is assumed to be valid.");
            return true;
        }
        if (this.verifier.hasCert()) {
            this.log.debug((Object)"Metadata validation failed because a validation certificate exists but the metadata is not signed");
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_not_signed, this.metadataFieldPath));
            return false;
        }
        return true;
    }

    public XmlSignatureVerifier getSigVerifier() {
        return this.verifier;
    }
}

