/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MetadataUrl;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.admin.api.model.fieldpaths.MetadataUrlPaths;
import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.MetadataUrlValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class MetadataUrlCertPairValidator
extends CompositeValidator {
    private CertificateValidator certificateValidator;
    private MetadataUrlValidator urlValidator;
    private String urlId;
    private String certId;
    private X509File x509File;
    private boolean isCreate;
    private final PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();

    public MetadataUrlCertPairValidator(MetadataUrl metadataUrl, boolean isCreate) {
        this.urlValidator = new MetadataUrlValidator(metadataUrl, true, isCreate);
        this.urlId = metadataUrl.getId();
        this.x509File = metadataUrl.getValidateSignature() != false ? metadataUrl.getX509File() : null;
        this.isCreate = isCreate;
        this.certId = this.x509File != null ? this.x509File.getId() : null;
    }

    @Override
    public boolean validate() {
        this.addValidator((Validator)this.urlValidator);
        if (this.urlId != null) {
            this.addValidator((Validator)new IdValidator(this.urlId, true, false, 0, 33, MetadataUrlPaths.getId()));
        }
        if (this.x509File != null) {
            if (StringUtils.isBlank((String)this.x509File.getFileData())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.cert_import_data_required, MetadataUrlPaths.getX509FileData()));
            } else {
                this.certificateValidator = new CertificateValidator(this.x509File.getFileData(), MetadataUrlPaths.getX509FileData(), false);
                this.addValidator((Validator)this.certificateValidator);
            }
            if (this.certId != null) {
                this.addValidator((Validator)new IdValidator(this.certId, true, true, 0, 33, MetadataUrlPaths.getX509FileId()));
                try {
                    if (this.isCreate && this.certManager.getCert(this.certId) != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_cert_id_duplicate, MetadataUrlPaths.getX509FileId()));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        super.validate();
        return !this.hasErrors();
    }

    public Cert getCert() {
        if (this.certificateValidator != null) {
            return this.certificateValidator.getCert();
        }
        return null;
    }

    public void validateCertIdOnUpdate(String existingCertId) {
        try {
            if (this.certId != null && !this.certId.equals(existingCertId) && this.certManager.getCert(this.certId) != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_cert_id_duplicate, MetadataUrlPaths.getX509FileId()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

