/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.MetadataSignatureValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.util.MetadataConnections;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.domain.util.metadataimport.NoMatchingProtocolException;
import org.sourceid.saml20.domain.util.metadataimport.NoSuitableConnectionException;
import org.sourceid.websso.Protocol;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class MetadataValidator
extends AbstractValidator {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final MetadataImportExportUtil.ImportExpectedConnectionType expectedConnType;
    private final Protocol expectedProtocol;
    private final InputStream samlMetadataStream;
    private final String metadataFieldPath;
    private final MetadataSignatureValidator mdSigValidator;
    private XmlObject metadataXmlObject = null;
    private boolean initMetadataFailed = false;
    private ConnectionBase sourceConnection;
    private Collection<ConnectionBase> importedConnectionList;
    private Long validUntil = null;
    private boolean validateAllConnection = true;
    private boolean invalidCert = false;
    private boolean validateSignature = true;

    public MetadataValidator(MetadataImportExportUtil.ImportExpectedConnectionType expectedConnType, Protocol expectedProtocol, InputStream samlStream, boolean errorOnNoCert, Cert verificationCert, String metadataFieldPath, String verificationCertFieldPath) {
        this.expectedConnType = expectedConnType;
        this.expectedProtocol = expectedProtocol;
        this.samlMetadataStream = samlStream;
        this.metadataFieldPath = metadataFieldPath;
        this.initXmlAndVerifier();
        this.mdSigValidator = this.initMetadataFailed ? null : new MetadataSignatureValidator(this.metadataXmlObject, errorOnNoCert, verificationCert, metadataFieldPath, verificationCertFieldPath);
    }

    public MetadataValidator(MetadataImportExportUtil.ImportExpectedConnectionType expectedConnType, Protocol expectedProtocol, InputStream samlStream, String metadataFieldPath) {
        this.expectedConnType = expectedConnType;
        this.expectedProtocol = expectedProtocol;
        this.samlMetadataStream = samlStream;
        this.metadataFieldPath = metadataFieldPath;
        this.initXmlAndVerifier();
        this.mdSigValidator = null;
        this.validateSignature = false;
    }

    public ConnectionBase getSourceConnection() {
        return this.sourceConnection;
    }

    public void setSourceConnection(ConnectionBase sourceConnection) {
        this.sourceConnection = sourceConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initXmlAndVerifier() {
        try {
            Node node = XmlBeansUtil.parseToNode((InputStream)this.samlMetadataStream);
            this.metadataXmlObject = XmlObject.Factory.parse((Node)node);
        }
        catch (Exception e) {
            this.initMetadataFailed = true;
            this.log.debug((Object)"Importing metadata file caused a exception.", (Throwable)e);
            ValidationError ve = ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_saml_metadata_invalid, this.metadataFieldPath);
            String devMessage = null;
            if (e.getCause() != null) {
                devMessage = e.getCause() instanceof SAXParseException ? this.getMessageExcludingStackTrace(e) : e.getCause().toString();
            } else if (e.getMessage() != null) {
                devMessage = e.getMessage();
            }
            ve.setDeveloperMessage(devMessage);
            this.appendError(ve);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.samlMetadataStream);
        }
    }

    private String getMessageExcludingStackTrace(Exception e) {
        String trace = ExceptionUtils.getStackTrace((Throwable)ExceptionUtils.getRootCause((Throwable)e));
        String errorMessage = e.getCause().toString();
        if (errorMessage.contains(trace)) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf(trace));
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        if (this.initMetadataFailed) {
            return false;
        }
        if (this.validateSignature) {
            this.invalidCert = !this.mdSigValidator.validate();
            this.appendErrors(this.mdSigValidator.getErrors());
        }
        InputStream inputStream = null;
        try {
            inputStream = this.metadataXmlObject.newInputStream();
            MetadataConnections metadataConnections = null;
            metadataConnections = this.validateAllConnection ? MetadataImportExportUtil.generateConnectionsFromMetadata((InputStream)inputStream, (MetadataImportExportUtil.ImportExpectedConnectionType)this.expectedConnType, (Protocol)this.expectedProtocol) : MetadataImportExportUtil.getAllConnections((InputStream)inputStream);
            if (metadataConnections != null) {
                this.importedConnectionList = metadataConnections.getConnections();
                this.validUntil = metadataConnections.getValidUntil();
            }
        }
        catch (NoSuitableConnectionException e) {
            if (this.expectedConnType == null && !this.validateAllConnection) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_saml_metadata_invalid, this.metadataFieldPath));
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_no_suitable_connections, this.metadataFieldPath));
            }
        }
        catch (NoMatchingProtocolException e) {
            StringBuilder supportedProtocolString = new StringBuilder();
            Iterator protocolIt = e.getSupportedProtocols().iterator();
            while (protocolIt.hasNext()) {
                Protocol protocol = (Protocol)protocolIt.next();
                supportedProtocolString.append(protocol.getLabel());
                if (!protocolIt.hasNext()) continue;
                supportedProtocolString.append(" ");
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_wrong_protocol, this.metadataFieldPath, new Object[]{this.expectedProtocol.getLabel(), supportedProtocolString.toString()}));
        }
        catch (MetadataImportException e) {
            ValidationError ve = ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_saml_metadata_invalid, this.metadataFieldPath);
            ve.setDeveloperMessage(e.getMessage());
            this.appendError(ve);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return !this.hasErrors();
    }

    public boolean isInvalidCert() {
        return this.invalidCert;
    }

    public Collection<ConnectionBase> getImportedConnectionsList() {
        return this.importedConnectionList;
    }

    public XmlSignatureVerifier getSigVerifier() {
        if (this.mdSigValidator == null) {
            return null;
        }
        return this.mdSigValidator.getSigVerifier();
    }

    public XmlObject getMetadataXml() {
        return this.metadataXmlObject;
    }

    public Long getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Long validUntil) {
        this.validUntil = validUntil;
    }

    public boolean isValidateAllConnection() {
        return this.validateAllConnection;
    }

    public void setValidateAllConnection(boolean validateAllConnection) {
        this.validateAllConnection = validateAllConnection;
    }
}

