/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.NotificationSettingsPaths;
import com.pingidentity.admin.api.model.systemsettings.CertificateExpirationNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.NotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.ThreadPoolExhaustionNotificationSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;

public class NotificationSettingsValidator
extends AbstractValidator {
    private static final int MIN_WARNING_PERIOD = 1;
    private static final int MAX_WARNING_PERIOD = 99999;
    private static final int MIN_WARNING_PERIOD_CONSOLE_WARNING = 0;
    private static final NotificationPublisherPluginManager NOTIFICATION_PUBLISHER_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();
    private String rootFieldPath;
    private boolean notifyForLicenseEvents = false;
    private String licenseEventsEmailAddress;
    private boolean notifyForCertificateExpirations = false;
    private String certificateExpirationEmailAddress;
    private String certInitialWarningPeriod;
    private String certFinalWarningPeriod;
    private NotificationMode certExpirationNotificationMode;
    private boolean notifyForMetadata = false;
    private String metadataEventEmailAddress;
    private boolean notifyForThreadPoolExhaustion = false;
    private String threadPoolExhaustionEmailAddress;
    private NotificationMode threadPoolExhaustionNotificationMode;
    private boolean notifyForBulkheadAlerts = false;
    private String bulkheadAlertsEmailAddress;
    private NotificationMode bulkheadAlertsNotificationMode;
    private ResourceLink bulkheadNotificationPublisherRef;
    private boolean hasProvidedEmailSettings = false;
    private final String expiredCertUIWarningDays;
    private final String expiringCertUIWarningDays;
    private ValidatorContext validatorContext;
    private boolean enforceRequiredCertUIWarningDays;

    public NotificationSettingsValidator(boolean notifyForLicenseEvents, String licenseEventsEmailAddress, boolean notifyForCertificateExpirations, String certificateExpirationEmailAddress, String certInitialWarningPeriod, String certFinalWarningPeriod, boolean notifyForMetadata, String metadataEventEmailAddress, NotificationMode certExpirationNotificationMode, String expiringCertUIWarningDays, String expiredCertUIWarningDays, boolean enforceRequiredCertUIWarningDays, boolean notifyForThreadPoolExhaustion, String threadPoolExhaustionEmailAddress, NotificationMode threadPoolExhaustionNotificationMode, boolean notifyForBulkheadAlerts, String bulkheadAlertsEmailAddress, NotificationMode bulkheadAlertsNotificationMode) {
        this.notifyForLicenseEvents = notifyForLicenseEvents;
        this.licenseEventsEmailAddress = licenseEventsEmailAddress;
        this.notifyForCertificateExpirations = notifyForCertificateExpirations;
        this.certificateExpirationEmailAddress = certificateExpirationEmailAddress;
        this.certInitialWarningPeriod = certInitialWarningPeriod;
        this.certFinalWarningPeriod = certFinalWarningPeriod;
        this.notifyForMetadata = notifyForMetadata;
        this.metadataEventEmailAddress = metadataEventEmailAddress;
        this.certExpirationNotificationMode = certExpirationNotificationMode;
        this.expiringCertUIWarningDays = expiringCertUIWarningDays;
        this.expiredCertUIWarningDays = expiredCertUIWarningDays;
        this.enforceRequiredCertUIWarningDays = enforceRequiredCertUIWarningDays;
        this.notifyForThreadPoolExhaustion = notifyForThreadPoolExhaustion;
        this.threadPoolExhaustionEmailAddress = threadPoolExhaustionEmailAddress;
        this.threadPoolExhaustionNotificationMode = threadPoolExhaustionNotificationMode;
        this.notifyForBulkheadAlerts = notifyForBulkheadAlerts;
        this.bulkheadAlertsEmailAddress = bulkheadAlertsEmailAddress;
        this.bulkheadAlertsNotificationMode = bulkheadAlertsNotificationMode;
    }

    public NotificationSettingsValidator(String rootFieldPath, NotificationSettings settings, boolean hasProvidedEmailSettings, ValidatorContext validatorContext) {
        boolean loggingOnly;
        this.rootFieldPath = rootFieldPath;
        this.hasProvidedEmailSettings = hasProvidedEmailSettings;
        this.validatorContext = validatorContext;
        if (settings.getLicenseEvents() != null) {
            this.notifyForLicenseEvents = true;
            this.licenseEventsEmailAddress = settings.getLicenseEvents().getEmailAddress();
            if (settings.getLicenseEvents().getNotificationPublisherRef() != null) {
                this.validateNotificationPublisher(settings.getLicenseEvents().getNotificationPublisherRef(), NotificationSettingsPaths.getLicenseEventsNotificationPublisher());
            } else if (NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_default_or_specific_required, NotificationSettingsPaths.getLicenseEventsNotificationPublisher()));
            }
        }
        this.populateMetadataNotificationSettings(settings);
        if (settings.getCertificateExpirations() != null) {
            this.notifyForCertificateExpirations = true;
            CertificateExpirationNotificationSettings certificateExpirations = settings.getCertificateExpirations();
            this.certificateExpirationEmailAddress = certificateExpirations.getEmailAddress();
            if (certificateExpirations.getInitialWarningPeriod() != null) {
                this.certInitialWarningPeriod = Integer.toString(certificateExpirations.getInitialWarningPeriod());
            }
            if (certificateExpirations.getFinalWarningPeriod() != null) {
                this.certFinalWarningPeriod = Integer.toString(certificateExpirations.getFinalWarningPeriod());
            }
            this.certExpirationNotificationMode = certificateExpirations.getNotificationMode();
            boolean bl = loggingOnly = this.certExpirationNotificationMode != null && this.certExpirationNotificationMode.equals((Object)NotificationMode.LOGGING_ONLY);
            if (certificateExpirations.getNotificationPublisherRef() != null) {
                if (loggingOnly) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_should_not_have_publisher, NotificationSettingsPaths.getCertificateExpirationsNotificationPublisher()));
                }
                this.validateNotificationPublisher(certificateExpirations.getNotificationPublisherRef(), NotificationSettingsPaths.getCertificateExpirationsNotificationPublisher());
            } else if (!loggingOnly && NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_default_or_specific_required, NotificationSettingsPaths.getCertificateExpirationsNotificationPublisher()));
            }
        }
        if (settings.getThreadPoolExhaustionNotificationSettings() != null) {
            this.notifyForThreadPoolExhaustion = true;
            ThreadPoolExhaustionNotificationSettings threadPoolExhaustionNotificationSettings = settings.getThreadPoolExhaustionNotificationSettings();
            this.threadPoolExhaustionEmailAddress = threadPoolExhaustionNotificationSettings.getEmailAddress();
            this.threadPoolExhaustionNotificationMode = threadPoolExhaustionNotificationSettings.getNotificationMode();
            boolean bl = loggingOnly = this.threadPoolExhaustionNotificationMode != null && this.threadPoolExhaustionNotificationMode.equals((Object)NotificationMode.LOGGING_ONLY);
            if (threadPoolExhaustionNotificationSettings.getNotificationPublisherRef() != null) {
                if (loggingOnly) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_should_not_have_publisher, NotificationSettingsPaths.getThreadPoolExhaustionNotificationPublisher()));
                }
                this.validateNotificationPublisher(threadPoolExhaustionNotificationSettings.getNotificationPublisherRef(), NotificationSettingsPaths.getThreadPoolExhaustionNotificationPublisher());
            } else if (!loggingOnly && NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_default_or_specific_required, NotificationSettingsPaths.getThreadPoolExhaustionNotificationPublisher()));
            }
        }
        if (settings.isNotifyAdminUserPasswordChanges()) {
            if (settings.getAccountChangesNotificationPublisherRef() != null) {
                this.validateNotificationPublisher(settings.getAccountChangesNotificationPublisherRef(), NotificationSettingsPaths.getAccountChangesNotificationPublisherRef());
            } else if (NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_default_or_specific_required, NotificationSettingsPaths.getAccountChangesNotificationPublisherRef()));
            }
        } else if (settings.getAccountChangesNotificationPublisherRef() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_should_not_have_publisher, NotificationSettingsPaths.getAccountChangesNotificationPublisherRef()));
        }
        this.expiredCertUIWarningDays = settings.getExpiredCertificateAdministrativeConsoleWarningDays() == null ? null : Integer.toString(settings.getExpiredCertificateAdministrativeConsoleWarningDays());
        this.expiringCertUIWarningDays = settings.getExpiringCertificateAdministrativeConsoleWarningDays() == null ? null : Integer.toString(settings.getExpiringCertificateAdministrativeConsoleWarningDays());
        this.populateBulkheadNotificationSettings(settings);
    }

    private void validateCertConsoleWarningDays(String warningDaysStr, String fieldPath, String fieldName, ApiMessageKey invalidWarningKey) {
        if (StringUtils.isEmpty((String)warningDaysStr)) {
            if (this.enforceRequiredCertUIWarningDays && (this.validatorContext == null || !this.validatorContext.isBulkConfigRequest())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, fieldPath, new Object[]{fieldName}));
            }
        } else {
            try {
                Integer warningDays = Integer.parseInt(warningDaysStr);
                if (warningDays < 0 || warningDays > 99999) {
                    this.appendError(ValidationErrorFactory.getInstance().create(invalidWarningKey, fieldPath, new Object[]{0, 99999}));
                }
            }
            catch (NumberFormatException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(invalidWarningKey, fieldPath, new Object[]{0, 99999}));
            }
        }
    }

    private void validateNotificationPublisher(ResourceLink notificationPublisherRef, String path) {
        String notificationPublisherId = notificationPublisherRef.getId();
        if (StringUtils.isBlank((String)notificationPublisherId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_id_missing, path));
        } else {
            NotificationPublisherPluginManager pluginMgr = MgmtFactory.getNotificationPublisherPluginManager();
            NotificationSenderPluginInstance instance = (NotificationSenderPluginInstance)pluginMgr.getInstance(notificationPublisherId);
            if (instance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_not_found, path, new Object[]{notificationPublisherId}));
            }
        }
    }

    private void populateMetadataNotificationSettings(NotificationSettings settings) {
        if (settings != null && settings.getMetadataNotificationSettings() != null) {
            this.notifyForMetadata = true;
            this.metadataEventEmailAddress = settings.getMetadataNotificationSettings().getEmailAddress();
            if (settings.getMetadataNotificationSettings().getNotificationPublisherRef() != null) {
                this.validateNotificationPublisher(settings.getMetadataNotificationSettings().getNotificationPublisherRef(), NotificationSettingsPaths.getMetadataNotificationPublisher());
            } else if (NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !this.hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_default_or_specific_required, NotificationSettingsPaths.getMetadataNotificationPublisher()));
            }
        }
    }

    private void populateBulkheadNotificationSettings(NotificationSettings settings) {
        if (settings != null && settings.getBulkheadAlertNotificationSettings() != null) {
            this.notifyForBulkheadAlerts = true;
            this.bulkheadAlertsNotificationMode = settings.getBulkheadAlertNotificationSettings().getNotificationMode();
            this.bulkheadAlertsEmailAddress = settings.getBulkheadAlertNotificationSettings().getEmailAddress();
            this.bulkheadNotificationPublisherRef = settings.getBulkheadAlertNotificationSettings().getNotificationPublisherRef();
            if (this.bulkheadNotificationPublisherRef != null) {
                this.validateNotificationPublisher(this.bulkheadNotificationPublisherRef, NotificationSettingsPaths.getBulkheadAlertNotificationPublisher());
            } else if (this.bulkheadAlertsNotificationMode != NotificationMode.LOGGING_ONLY && NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance() == null && !this.hasProvidedEmailSettings) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_required_bulkhead_alerts, NotificationSettingsPaths.getBulkheadAlertNotificationPublisher()));
            }
        }
    }

    public boolean validate() {
        EmailValidator emailValidator;
        if (this.notifyForLicenseEvents) {
            if (!this.internalLicenseSupportsNotifications()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_incompatible_license, this.getFieldPath(NotificationSettingsPaths.getLicenseEvents())));
            } else if (StringUtils.isBlank((String)this.licenseEventsEmailAddress)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_required_license_events, this.getFieldPath(NotificationSettingsPaths.getLicenseEventsEmailAddress())));
            } else {
                emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(this.licenseEventsEmailAddress)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_invalid_license_events, this.getFieldPath(NotificationSettingsPaths.getLicenseEventsEmailAddress())));
                }
            }
        }
        if (this.notifyForCertificateExpirations) {
            switch (this.certExpirationNotificationMode) {
                case NOTIFICATION_PUBLISHER: {
                    if (StringUtils.isBlank((String)this.certificateExpirationEmailAddress)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_required_cert_expirations, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsEmailAddress())));
                        break;
                    }
                    emailValidator = EmailValidator.getInstance();
                    if (emailValidator.isValid(this.certificateExpirationEmailAddress)) break;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_invalid_cert_expirations, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsEmailAddress())));
                    break;
                }
                case LOGGING_ONLY: {
                    if (!StringUtils.isNotBlank((String)this.certificateExpirationEmailAddress)) break;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_not_required_cert_expirations, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsEmailAddress())));
                    break;
                }
            }
            int initialWarningPeriod = -1;
            if (StringUtils.isNotBlank((String)this.certInitialWarningPeriod)) {
                try {
                    initialWarningPeriod = Integer.parseInt(this.certInitialWarningPeriod);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (initialWarningPeriod < 1 || initialWarningPeriod > 99999) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_cert_initial_warning_invalid, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsInitialWarningPeriod()), new Object[]{1, 99999}));
                }
            }
            int finalWarningPeriod = -1;
            if (StringUtils.isBlank((String)this.certFinalWarningPeriod)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_cert_final_warning_required, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsFinalWarningPeriod())));
            } else {
                try {
                    finalWarningPeriod = Integer.parseInt(this.certFinalWarningPeriod);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (finalWarningPeriod < 1 || finalWarningPeriod > 99999) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_cert_final_warning_invalid, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirationsFinalWarningPeriod()), new Object[]{1, 99999}));
                }
            }
            if (initialWarningPeriod != -1 && finalWarningPeriod != -1 && initialWarningPeriod < finalWarningPeriod) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_cert_final_greater_than_initial, this.getFieldPath(NotificationSettingsPaths.getCertificateExpirations())));
            }
        }
        if (this.notifyForMetadata) {
            if (StringUtils.isBlank((String)this.metadataEventEmailAddress)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_required_metadata_events, this.getFieldPath(NotificationSettingsPaths.getMetadataEventsEmailAddress())));
            } else {
                emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(this.metadataEventEmailAddress)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_invalid_metadata_events, this.getFieldPath(NotificationSettingsPaths.getMetadataEventsEmailAddress())));
                }
            }
        }
        this.validateCertConsoleWarningDays(this.expiredCertUIWarningDays, NotificationSettingsPaths.getExpiredCertificateAdministrativeConsoleWarningDays(), "Days after certificate expiry for administrative console warning", ApiMessageKey.notifications_cert_expired_admin_console_warning_days_invalid);
        this.validateCertConsoleWarningDays(this.expiringCertUIWarningDays, NotificationSettingsPaths.getExpiringCertificateAdministrativeConsoleWarningDays(), "Days before certificate expiry for administrative console warning", ApiMessageKey.notifications_cert_expiring_admin_console_warning_days_invalid);
        if (this.notifyForThreadPoolExhaustion) {
            if (this.threadPoolExhaustionNotificationMode == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_thread_pool_exhaustion_notification_mode_required, this.getFieldPath(NotificationSettingsPaths.getThreadPoolExhaustionNotificationMode())));
            } else {
                switch (this.threadPoolExhaustionNotificationMode) {
                    case NOTIFICATION_PUBLISHER: {
                        if (StringUtils.isBlank((String)this.threadPoolExhaustionEmailAddress)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_required_thread_pool_exhaustion, this.getFieldPath(NotificationSettingsPaths.getThreadPoolExhaustionEmailAddress())));
                            break;
                        }
                        emailValidator = EmailValidator.getInstance();
                        if (emailValidator.isValid(this.threadPoolExhaustionEmailAddress)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_invalid_thread_pool_exhaustion, this.getFieldPath(NotificationSettingsPaths.getThreadPoolExhaustionEmailAddress())));
                        break;
                    }
                    case LOGGING_ONLY: {
                        if (!StringUtils.isNotBlank((String)this.threadPoolExhaustionEmailAddress)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_not_required_thread_pool_exhaustion, this.getFieldPath(NotificationSettingsPaths.getThreadPoolExhaustionEmailAddress())));
                        break;
                    }
                }
            }
        }
        this.validateBulkheadAlertsNotifications();
        return !this.hasErrors();
    }

    private void validateBulkheadAlertsNotifications() {
        if (this.notifyForBulkheadAlerts) {
            if (this.bulkheadAlertsNotificationMode == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_bulkhead_alerts_notification_mode_required, this.getFieldPath(NotificationSettingsPaths.getBulkheadAlertNotificationMode())));
            } else {
                switch (this.bulkheadAlertsNotificationMode) {
                    case NOTIFICATION_PUBLISHER: {
                        if (StringUtils.isBlank((String)this.bulkheadAlertsEmailAddress)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_required_bulkhead_alerts, this.getFieldPath(NotificationSettingsPaths.getBulkheadAlertEmailAddress())));
                            break;
                        }
                        EmailValidator emailValidator = EmailValidator.getInstance();
                        if (emailValidator.isValid(this.bulkheadAlertsEmailAddress)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_invalid_bulkhead_alerts, this.getFieldPath(NotificationSettingsPaths.getBulkheadAlertEmailAddress())));
                        break;
                    }
                    case LOGGING_ONLY: {
                        if (this.bulkheadNotificationPublisherRef != null) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_should_not_have_publisher, NotificationSettingsPaths.getBulkheadAlertNotificationPublisher()));
                        }
                        if (!StringUtils.isNotBlank((String)this.bulkheadAlertsEmailAddress)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notifications_email_not_required_bulkhead_alerts, this.getFieldPath(NotificationSettingsPaths.getBulkheadAlertEmailAddress())));
                        break;
                    }
                }
            }
        }
    }

    public static boolean licenseSupportsNotifications() {
        PingLicense pl = LicenseManager.getLicense();
        return pl.hasExpirationDate() && pl.isSendNotifications();
    }

    protected boolean internalLicenseSupportsNotifications() {
        return NotificationSettingsValidator.licenseSupportsNotifications();
    }

    private String getFieldPath(String relativePath) {
        return this.rootFieldPath == null ? relativePath : this.rootFieldPath + "." + relativePath;
    }
}

