/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.OAuthDynamicClientRegistrationPluginManager;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class OAuthDynamicClientRegistrationPoliciesValidator
extends CompositeValidator {
    private List<ResourceLink> links = new ArrayList<ResourceLink>();
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private static final OAuthDynamicClientRegistrationPluginManager pluginManager = MgmtFactory.getOAuthDynamicClientRegistrationPluginManager();

    OAuthDynamicClientRegistrationPoliciesValidator(List<ResourceLink> links) {
        this.links = links;
    }

    @Override
    public boolean validate() {
        for (int i = 0; i < this.links.size(); ++i) {
            ResourceLink link = this.links.get(i);
            this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)pluginManager, link.getId(), ClientSettingsPaths.getPolicyRef(i), ApiMessageKey.oauth_client_setting_policy_not_found));
        }
        if (!super.validate()) {
            return false;
        }
        HashSet<ResourceLink> policiesSet = new HashSet<ResourceLink>();
        for (int i = 0; i < this.links.size(); ++i) {
            ResourceLink link = this.links.get(i);
            if (policiesSet.add(link)) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.duplicate_entry, ClientSettingsPaths.getPolicyRef(i), new Object[]{"Client Registration Policy", link.getId()}));
        }
        return !this.hasErrors();
    }
}

