/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.ClientSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;
import org.sourceid.oauth20.domain.ScopeUtil;

public class OAuthDynamicClientRegistrationScopeConstraintsValidator
extends AbstractValidator {
    private ClientSettings clientSettings;

    public OAuthDynamicClientRegistrationScopeConstraintsValidator(ClientSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    public boolean validate() {
        List<String> exclusiveScopes;
        HashSet validCommonScopes = new HashSet();
        validCommonScopes.addAll(ScopeUtil.getAllCommonScopeDescriptions().keySet());
        validCommonScopes.addAll(ScopeUtil.getCommonScopeGroupDescriptions().keySet());
        HashSet validExclusiveScopes = new HashSet();
        validExclusiveScopes.addAll(ScopeUtil.getAllExclusiveScopeDescriptions().keySet());
        validExclusiveScopes.addAll(ScopeUtil.getExclusiveScopeGroupDescriptions().keySet());
        List<String> commonScopes = this.clientSettings.getDynamicClientRegistration().getRestrictedCommonScopes();
        if (!this.clientSettings.getDynamicClientRegistration().isRestrictCommonScopes() && !commonScopes.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ClientSettingsPaths.getRestrictedCommonScopes(), new Object[]{"Restricted Common Scopes"}));
            return false;
        }
        if (commonScopes != null) {
            int index = 0;
            for (String commonScope : commonScopes) {
                if (!validCommonScopes.contains(commonScope)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_setting_restricted_common_scopes_invalid, ClientSettingsPaths.getRestrictedCommonScopes(index)));
                }
                ++index;
            }
        }
        if ((exclusiveScopes = this.clientSettings.getDynamicClientRegistration().getAllowedExclusiveScopes()) != null) {
            int index = 0;
            for (String exclusiveScope : exclusiveScopes) {
                if (!validExclusiveScopes.contains(exclusiveScope)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_setting_allowed_exclusive_scopes_invalid, ClientSettingsPaths.getAllowedExclusiveScopes(index)));
                }
                ++index;
            }
        }
        return !this.hasErrors();
    }
}

