/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.OAuthOidcKeysSettings;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.OAuthOidcKeysPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.OAuthOidcDynamicKeysValidator;
import com.pingidentity.admin.api.validator.OAuthOidcKeysBaseValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class OAuthOidcKeysValidator
extends CompositeValidator {
    static PkCertManager pkCertMgr = MgmtFactory.getDsigPkCertManager();
    static DSignRotationSettingsManager rotationManger = MgmtFactory.getDSignRotationSettingsManager();
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final OAuthOidcKeysSettings oauthOidcKeysSettings;
    private static final int P256_KEY_SIZE = 256;
    private static final int P384_KEY_SIZE = 384;
    private static final int P521_KEY_SIZE = 521;
    private final boolean isAdditionalKeySet;

    public OAuthOidcKeysValidator(OAuthOidcKeysSettings requestOauthOidcKeysSettings, boolean isAdditionalKeySet) {
        OAuthOidcKeysBaseValidator.Builder baseValidatorBuilder = new OAuthOidcKeysBaseValidator.Builder(StaticKeyType.SIGNING, isAdditionalKeySet);
        OAuthOidcKeysBaseValidator.Builder decryptionValidatorBuilder = new OAuthOidcKeysBaseValidator.Builder(StaticKeyType.DECRYPTION, false);
        decryptionValidatorBuilder.setSkipRsaValidation(true);
        if (requestOauthOidcKeysSettings.isStaticJwksEnabled() != null) {
            baseValidatorBuilder.setStaticJwksEnabled(requestOauthOidcKeysSettings.isStaticJwksEnabled());
            decryptionValidatorBuilder.setStaticJwksEnabled(requestOauthOidcKeysSettings.isStaticJwksEnabled());
        }
        if (requestOauthOidcKeysSettings.getP256ActiveCertRef() != null) {
            baseValidatorBuilder.setP256ActiveCertId(requestOauthOidcKeysSettings.getP256ActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP256PreviousCertRef() != null) {
            baseValidatorBuilder.setP256PreviousCertId(requestOauthOidcKeysSettings.getP256PreviousCertRef().getId());
        }
        baseValidatorBuilder.setP256ActiveKeyId(requestOauthOidcKeysSettings.getP256ActiveKeyId());
        baseValidatorBuilder.setP256PreviousKeyId(requestOauthOidcKeysSettings.getP256PreviousKeyId());
        if (requestOauthOidcKeysSettings.getP384ActiveCertRef() != null) {
            baseValidatorBuilder.setP384ActiveCertId(requestOauthOidcKeysSettings.getP384ActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP384PreviousCertRef() != null) {
            baseValidatorBuilder.setP384PreviousCertId(requestOauthOidcKeysSettings.getP384PreviousCertRef().getId());
        }
        baseValidatorBuilder.setP384ActiveKeyId(requestOauthOidcKeysSettings.getP384ActiveKeyId());
        baseValidatorBuilder.setP384PreviousKeyId(requestOauthOidcKeysSettings.getP384PreviousKeyId());
        if (requestOauthOidcKeysSettings.getP521ActiveCertRef() != null) {
            baseValidatorBuilder.setP521ActiveCertId(requestOauthOidcKeysSettings.getP521ActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP521PreviousCertRef() != null) {
            baseValidatorBuilder.setP521PreviousCertId(requestOauthOidcKeysSettings.getP521PreviousCertRef().getId());
        }
        baseValidatorBuilder.setP521ActiveKeyId(requestOauthOidcKeysSettings.getP521ActiveKeyId());
        baseValidatorBuilder.setP521PreviousKeyId(requestOauthOidcKeysSettings.getP521PreviousKeyId());
        if (requestOauthOidcKeysSettings.getRsaActiveCertRef() != null) {
            baseValidatorBuilder.setRsaActiveCertId(requestOauthOidcKeysSettings.getRsaActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getRsaPreviousCertRef() != null) {
            baseValidatorBuilder.setRsaPreviousCertId(requestOauthOidcKeysSettings.getRsaPreviousCertRef().getId());
        }
        baseValidatorBuilder.setRsaActiveKeyId(requestOauthOidcKeysSettings.getRsaActiveKeyId());
        baseValidatorBuilder.setRsaPreviousKeyId(requestOauthOidcKeysSettings.getRsaPreviousKeyId());
        if (requestOauthOidcKeysSettings.isP256PublishX5cParameter() != null) {
            baseValidatorBuilder.setP256PublishX5cParameter(requestOauthOidcKeysSettings.isP256PublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isP384PublishX5cParameter() != null) {
            baseValidatorBuilder.setP384PublishX5cParameter(requestOauthOidcKeysSettings.isP384PublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isP521PublishX5cParameter() != null) {
            baseValidatorBuilder.setP521PublishX5cParameter(requestOauthOidcKeysSettings.isP521PublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isRsaPublishX5cParameter() != null) {
            baseValidatorBuilder.setRsaPublishX5cParameter(requestOauthOidcKeysSettings.isRsaPublishX5cParameter());
        }
        baseValidatorBuilder.setKeysRequiredByJwtAtm(MgmtFactory.getBearerAccessTokenMgmtPluginMgr());
        if (requestOauthOidcKeysSettings.getP256DecryptionActiveCertRef() != null) {
            decryptionValidatorBuilder.setP256ActiveCertId(requestOauthOidcKeysSettings.getP256DecryptionActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP256DecryptionPreviousCertRef() != null) {
            decryptionValidatorBuilder.setP256PreviousCertId(requestOauthOidcKeysSettings.getP256DecryptionPreviousCertRef().getId());
        }
        decryptionValidatorBuilder.setP256ActiveKeyId(requestOauthOidcKeysSettings.getP256DecryptionActiveKeyId());
        decryptionValidatorBuilder.setP256PreviousKeyId(requestOauthOidcKeysSettings.getP256DecryptionPreviousKeyId());
        if (requestOauthOidcKeysSettings.getP384DecryptionActiveCertRef() != null) {
            decryptionValidatorBuilder.setP384ActiveCertId(requestOauthOidcKeysSettings.getP384DecryptionActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP384DecryptionPreviousCertRef() != null) {
            decryptionValidatorBuilder.setP384PreviousCertId(requestOauthOidcKeysSettings.getP384DecryptionPreviousCertRef().getId());
        }
        decryptionValidatorBuilder.setP384ActiveKeyId(requestOauthOidcKeysSettings.getP384DecryptionActiveKeyId());
        decryptionValidatorBuilder.setP384PreviousKeyId(requestOauthOidcKeysSettings.getP384DecryptionPreviousKeyId());
        if (requestOauthOidcKeysSettings.getP521DecryptionActiveCertRef() != null) {
            decryptionValidatorBuilder.setP521ActiveCertId(requestOauthOidcKeysSettings.getP521DecryptionActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getP521DecryptionPreviousCertRef() != null) {
            decryptionValidatorBuilder.setP521PreviousCertId(requestOauthOidcKeysSettings.getP521DecryptionPreviousCertRef().getId());
        }
        decryptionValidatorBuilder.setP521ActiveKeyId(requestOauthOidcKeysSettings.getP521DecryptionActiveKeyId());
        decryptionValidatorBuilder.setP521PreviousKeyId(requestOauthOidcKeysSettings.getP521DecryptionPreviousKeyId());
        if (requestOauthOidcKeysSettings.getRsaDecryptionActiveCertRef() != null) {
            decryptionValidatorBuilder.setRsaActiveCertId(requestOauthOidcKeysSettings.getRsaDecryptionActiveCertRef().getId());
        }
        if (requestOauthOidcKeysSettings.getRsaDecryptionPreviousCertRef() != null) {
            decryptionValidatorBuilder.setRsaPreviousCertId(requestOauthOidcKeysSettings.getRsaDecryptionPreviousCertRef().getId());
        }
        decryptionValidatorBuilder.setRsaActiveKeyId(requestOauthOidcKeysSettings.getRsaDecryptionActiveKeyId());
        decryptionValidatorBuilder.setRsaPreviousKeyId(requestOauthOidcKeysSettings.getRsaDecryptionPreviousKeyId());
        if (requestOauthOidcKeysSettings.isP256DecryptionPublishX5cParameter() != null) {
            decryptionValidatorBuilder.setP256PublishX5cParameter(requestOauthOidcKeysSettings.isP256DecryptionPublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isP384DecryptionPublishX5cParameter() != null) {
            decryptionValidatorBuilder.setP384PublishX5cParameter(requestOauthOidcKeysSettings.isP384DecryptionPublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isP521DecryptionPublishX5cParameter() != null) {
            decryptionValidatorBuilder.setP521PublishX5cParameter(requestOauthOidcKeysSettings.isP521DecryptionPublishX5cParameter());
        }
        if (requestOauthOidcKeysSettings.isRsaDecryptionPublishX5cParameter() != null) {
            decryptionValidatorBuilder.setRsaPublishX5cParameter(requestOauthOidcKeysSettings.isRsaDecryptionPublishX5cParameter());
        }
        baseValidatorBuilder.setRsaAlgTypesActiveCustomKeyIds(requestOauthOidcKeysSettings.getRsaAlgorithmActiveKeyIds());
        baseValidatorBuilder.setRsaAlgTypesPreviousCustomKeyIds(requestOauthOidcKeysSettings.getRsaAlgorithmPreviousKeyIds());
        OAuthOidcKeysBaseValidator baseValidator = baseValidatorBuilder.build();
        OAuthOidcKeysBaseValidator decryptionValidator = decryptionValidatorBuilder.build();
        this.addValidator((Validator)baseValidator);
        this.addValidator((Validator)decryptionValidator);
        Boolean publishDynamicKeyX5cs = requestOauthOidcKeysSettings.getPublishDynamicKeyX5cs();
        OAuthOidcDynamicKeysValidator.Builder oAuthOidcDynamicKeysValidatorBuilder = new OAuthOidcDynamicKeysValidator.Builder(this.errorFactory, Boolean.TRUE.equals(publishDynamicKeyX5cs));
        if (requestOauthOidcKeysSettings.getDynamicKeyCertificateInformation() != null) {
            oAuthOidcDynamicKeysValidatorBuilder = oAuthOidcDynamicKeysValidatorBuilder.certOrgName(requestOauthOidcKeysSettings.getDynamicKeyCertificateInformation().getOrganization()).certCountry(requestOauthOidcKeysSettings.getDynamicKeyCertificateInformation().getCountry());
        }
        this.addValidator((Validator)oAuthOidcDynamicKeysValidatorBuilder.build());
        this.oauthOidcKeysSettings = requestOauthOidcKeysSettings;
        this.isAdditionalKeySet = isAdditionalKeySet;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.oauthOidcKeysSettings.isStaticJwksEnabled() == null && !this.isAdditionalKeySet) {
            this.appendError(this.errorFactory.create(ApiMessageKey.model_parameter_null, OAuthOidcKeysPaths.getStaticJwksEnabledPath(), new Object[]{OAuthOidcKeysPaths.getStaticJwksEnabledPath()}));
            return false;
        }
        if (this.isAdditionalKeySet || this.oauthOidcKeysSettings.isStaticJwksEnabled().booleanValue()) {
            if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP256ActiveCertRef(), 256)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP256ActiveCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-256 curve"}));
            }
            if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP384ActiveCertRef(), 384)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP384ActiveCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-384 curve"}));
            }
            if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP521ActiveCertRef(), 521)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP521ActiveCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-521 curve"}));
            }
            if (!OAuthOidcKeysValidator.isResourceLinkValidRsa(this.oauthOidcKeysSettings.getRsaActiveCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getRsaActiveCertPath(), new Object[]{StaticKeyType.SIGNING, "RSA"}));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP256ActiveCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP256ActiveCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP256PreviousCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP256PreviousCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP384ActiveCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP384ActiveCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP384PreviousCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP384PreviousCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP521ActiveCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP521ActiveCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getP521PreviousCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getP521PreviousCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getRsaActiveCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getRsaActiveCertPath()));
            }
            if (OAuthOidcKeysValidator.isResourceLinkRotationCert(this.oauthOidcKeysSettings.getRsaPreviousCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiMessageKeyCertRotationEnabled(), this.getApiKeyMessageRsaPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP256PreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP256PreviousCertRef(), 256)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP256PreviousCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-256 curve"}));
            }
            if (this.oauthOidcKeysSettings.getP384PreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP384PreviousCertRef(), 384)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP384PreviousCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-384 curve"}));
            }
            if (this.oauthOidcKeysSettings.getP521PreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP521PreviousCertRef(), 521)) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getP521PreviousCertPath(), new Object[]{StaticKeyType.SIGNING, "EC with P-521 curve"}));
            }
            if (this.oauthOidcKeysSettings.getRsaPreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidRsa(this.oauthOidcKeysSettings.getRsaPreviousCertRef())) {
                this.appendError(this.errorFactory.create(this.getApiKeyMessageCertInvalidSigningAlgorithm(), this.getApiKeyMessageRsaPreviousCertPath(), new Object[]{StaticKeyType.SIGNING, "RSA"}));
            }
            this.validateDecryptionKeys();
        } else if (!this.isAdditionalKeySet) {
            if (this.oauthOidcKeysSettings.getP256ActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP256ActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP256PreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP256PreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP256PublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP256PublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getP384ActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP384ActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP384PreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP384PreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP384PublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP384PublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getP521ActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP521ActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP521PreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getP521PreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP521PublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP521PublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getRsaActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getRsaActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getRsaPreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, this.getApiKeyMessageRsaPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isRsaPublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getRsaPublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getP256DecryptionActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP256DecryptionActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP256DecryptionPreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP256DecryptionPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP256DecryptionPublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP256DecryptionPublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getP384DecryptionActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP384DecryptionActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP384DecryptionPreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP384DecryptionPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP384DecryptionPublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP384DecryptionPublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getP521DecryptionActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP521DecryptionActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getP521DecryptionPreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP521DecryptionPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isP521DecryptionPublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getP521DecryptionPublishX5cParameterPath()));
            }
            if (this.oauthOidcKeysSettings.getRsaDecryptionActiveCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getRsaDecryptionActiveCertPath()));
            }
            if (this.oauthOidcKeysSettings.getRsaDecryptionPreviousCertRef() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getRsaDecryptionPreviousCertPath()));
            }
            if (this.oauthOidcKeysSettings.isRsaDecryptionPublishX5cParameter() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_disable_static_keys_require_no_certs, OAuthOidcKeysPaths.getRsaDecryptionPublishX5cParameterPath()));
            }
        }
        return !this.hasErrors();
    }

    protected String getRsaActiveCertPath() {
        return OAuthOidcKeysPaths.getRsaActiveCertPath();
    }

    protected String getApiKeyMessageRsaPreviousCertPath() {
        return OAuthOidcKeysPaths.getRsaPreviousCertPath();
    }

    protected String getP521PreviousCertPath() {
        return OAuthOidcKeysPaths.getP521PreviousCertPath();
    }

    protected String getP521ActiveCertPath() {
        return OAuthOidcKeysPaths.getP521ActiveCertPath();
    }

    protected String getP384PreviousCertPath() {
        return OAuthOidcKeysPaths.getP384PreviousCertPath();
    }

    protected String getP384ActiveCertPath() {
        return OAuthOidcKeysPaths.getP384ActiveCertPath();
    }

    protected String getP256ActiveCertPath() {
        return OAuthOidcKeysPaths.getP256ActiveCertPath();
    }

    protected String getP256PreviousCertPath() {
        return OAuthOidcKeysPaths.getP256PreviousCertPath();
    }

    protected void validateDecryptionKeys() {
        if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP256DecryptionActiveCertRef(), 256)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP256DecryptionActiveCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-256 curve"}));
        }
        if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP384DecryptionActiveCertRef(), 384)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP384DecryptionActiveCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-384 curve"}));
        }
        if (!OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP521DecryptionActiveCertRef(), 521)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP521DecryptionActiveCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-521 curve"}));
        }
        if (!OAuthOidcKeysValidator.isResourceLinkValidRsa(this.oauthOidcKeysSettings.getRsaDecryptionActiveCertRef())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getRsaDecryptionActiveCertPath(), new Object[]{StaticKeyType.DECRYPTION, "RSA"}));
        }
        if (this.oauthOidcKeysSettings.getP256DecryptionPreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP256DecryptionPreviousCertRef(), 256)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP256DecryptionPreviousCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-256 curve"}));
        }
        if (this.oauthOidcKeysSettings.getP384DecryptionPreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP384DecryptionPreviousCertRef(), 384)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP384DecryptionPreviousCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-384 curve"}));
        }
        if (this.oauthOidcKeysSettings.getP521DecryptionPreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidEc(this.oauthOidcKeysSettings.getP521DecryptionPreviousCertRef(), 521)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getP521DecryptionPreviousCertPath(), new Object[]{StaticKeyType.DECRYPTION, "EC with P-521 curve"}));
        }
        if (this.oauthOidcKeysSettings.getRsaDecryptionPreviousCertRef() != null && !OAuthOidcKeysValidator.isResourceLinkValidRsa(this.oauthOidcKeysSettings.getRsaDecryptionPreviousCertRef())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauthoidckeys_cert_invalid_for_decryption_algorithm, OAuthOidcKeysPaths.getRsaDecryptionPreviousCertPath(), new Object[]{StaticKeyType.DECRYPTION, "RSA"}));
        }
    }

    protected ApiMessageKey getApiKeyMessageCertInvalidSigningAlgorithm() {
        return ApiMessageKey.oauthoidckeys_cert_invalid_for_signing_algorithm;
    }

    private ApiMessageKey getApiMessageKeyCertRotationEnabled() {
        return ApiMessageKey.oauthoidckeys_cert_has_rotation_enabled;
    }

    protected static boolean isResourceLinkValidEc(ResourceLink resourceLink, int publicKeySize) {
        if (resourceLink == null) {
            return true;
        }
        if (OAuthOidcKeysValidator.isResourceLinkPopulated(resourceLink)) {
            PkCert cert = pkCertMgr.getPkCert(resourceLink.getId());
            return cert != null && cert.getPublicKeySize() == publicKeySize;
        }
        return false;
    }

    protected static boolean isResourceLinkValidRsa(ResourceLink resourceLink) {
        if (resourceLink == null) {
            return true;
        }
        if (OAuthOidcKeysValidator.isResourceLinkPopulated(resourceLink)) {
            PkCert cert = pkCertMgr.getPkCert(resourceLink.getId());
            return cert != null && "RSA".equals(cert.getPublicKeyAlgorithm()) && cert.getPublicKeySize() >= 2048;
        }
        return false;
    }

    protected static boolean isResourceLinkRotationCert(ResourceLink resourceLink) {
        if (OAuthOidcKeysValidator.isResourceLinkPopulated(resourceLink)) {
            DSignRotationSetting rotationSetting = rotationManger.getRotationSetting(resourceLink.getId());
            return rotationSetting != null && rotationSetting.isEnableCertRotation();
        }
        return false;
    }

    protected static boolean isResourceLinkPopulated(ResourceLink resourceLink) {
        return resourceLink != null && StringUtils.isNotEmpty((String)resourceLink.getId());
    }

    public static enum StaticKeyType {
        SIGNING("Signing"),
        DECRYPTION("Decryption");

        private final String type;

        private StaticKeyType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.getType();
        }

        public String getType() {
            return this.type;
        }
    }
}

