/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.IdpAdapterMappingPaths;
import com.pingidentity.admin.api.model.oauth.SourceToUserKeyMapping;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class OAuthSourceToUserKeyValidator
extends BaseAttributeDataSourceValidator {
    protected static final AuthzServerManager AUTHZ_SERVER_MANAGER = MgmtFactory.getAuthzServerManager();

    public OAuthSourceToUserKeyValidator(SourceToUserKeyMapping mapping, ValidatorContext context) {
        super(context);
        this.init(mapping);
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.EXTENDED_CLIENT_METADATA), new ExtendedMetadataSourceTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        this.addAdditionalSourceValidators(validSources);
        if (mapping.getAttributeSources() != null && mapping.getAttributeSources().size() > 1) {
            int index = 0;
            for (AttributeSource attributeSource : mapping.getAttributeSources()) {
                this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", IdpAdapterMappingPaths.getAttributeSourceId(index)));
                ++index;
            }
        }
        this.mapDataStoreTypesToDsValidators(mapping, validSources);
        this.addValidator((Validator)new AttributeMappingValidator(mapping, this.getAllAttributeNames(), this.getSourceCoreSubstitutionVariables(), this.getSourceName(), validSources, "", context));
    }

    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForOAuthWebRedirectFlowMapping());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        return new TextSourceTypeValidatorBuilder();
    }

    protected Set<String> getAllAttributeNames() {
        return new HashSet<String>(AUTHZ_SERVER_MANAGER.getKeyNameContract().getAllAttrNamesSorted());
    }

    protected abstract void init(SourceToUserKeyMapping var1);

    protected abstract Set<String> getSourceCoreSubstitutionVariables();

    protected abstract void addAdditionalSourceValidators(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> var1);

    protected abstract String getSourceName();
}

