/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;

public class OgnlExpressionValidator
extends AbstractValidator {
    private final String value;
    private final String fieldPath;
    private final boolean doCheckForSubstitutionVars;
    private Map<String, String> substitutionValues = new HashMap<String, String>();
    private boolean ignoreDsExpressionReferences;
    private ValidatorContext validatorContext = null;

    public OgnlExpressionValidator(String value, String fieldPath, boolean doCheckForSubstitutionVars, Map<String, String> substitutionValues, ValidatorContext validatorContext) {
        this(value, fieldPath, doCheckForSubstitutionVars, substitutionValues, false);
        this.validatorContext = validatorContext;
    }

    public OgnlExpressionValidator(String value, String fieldPath, boolean doCheckForSubstitutionVars, Map<String, String> substitutionValues, boolean ignoreDsExpressionReferences) {
        this.value = value;
        this.fieldPath = fieldPath;
        this.doCheckForSubstitutionVars = doCheckForSubstitutionVars;
        this.substitutionValues = substitutionValues;
        this.ignoreDsExpressionReferences = ignoreDsExpressionReferences;
    }

    private boolean isDataStoreReference(String substitution) {
        return substitution != null && substitution.startsWith("ds.");
    }

    public boolean validate() {
        try {
            if (StringUtils.isNotEmpty((String)this.value) && this.validatorContext != null && !this.validatorContext.isAllowExpressionUpdates()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.expression_admin_role_required, this.fieldPath));
                return false;
            }
            Object parsedExpression = Ognl.parseExpression((String)this.value);
            if (this.doCheckForSubstitutionVars) {
                OgnlHelper ognlHelper = new OgnlHelper();
                ognlHelper.searchForAllVariableNames(parsedExpression);
                Optional<String> invalidSubstitution = ognlHelper.getList().stream().filter(substitution -> {
                    if (this.substitutionValues.containsKey(substitution)) {
                        return false;
                    }
                    if (this.isDataStoreReference((String)substitution)) {
                        if (this.ignoreDsExpressionReferences) {
                            return false;
                        }
                        return this.substitutionValues.keySet().stream().noneMatch(value -> substitution.startsWith(value + ";"));
                    }
                    return true;
                }).findFirst();
                if (invalidSubstitution.isPresent()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ognl_expression_invalid_attribute, this.fieldPath, new Object[]{invalidSubstitution.get()}));
                    return false;
                }
            }
        }
        catch (OgnlException e) {
            ValidationError validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.ognl_expression_invalid, this.fieldPath);
            validationError.setDeveloperMessage(e.getReason().toString().replace("\n", ""));
            this.appendError(validationError);
            return false;
        }
        catch (RuntimeException e) {
            ValidationError validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.ognl_expression_invalid, this.fieldPath);
            validationError.setDeveloperMessage(e.getCause().toString());
            this.appendError(validationError);
            return false;
        }
        return true;
    }
}

