/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OpenIdConnectPolicyPaths;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectPolicy;
import com.pingidentity.admin.api.validator.OpenIdConnectPolicyScopeAttributeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OpenIdConnectPolicyValidator
extends AbstractValidator {
    private static final int ID_TOKEN_LIFETIME_MIN_VALUE = 0;
    private static final int ID_TOKEN_LIFETIME_MAX_VALUE = 65535;
    private static final String DEFAULT_POLICY_ID = "default";
    static final int ID_TOKEN_TYP_VALUE_MAX_LENGTH = 256;
    private String id;
    private String name;
    private String idTokenLifetime;
    private boolean createMode;
    private String accessTokenManagerId;
    private String idTokenTypHeaderValue;
    private Set<String> allAttributeNames;
    private Map<String, ParameterValues> scopeAttributeMappings;

    public OpenIdConnectPolicyValidator(OpenIdConnectPolicy policy, boolean createMode) {
        if (policy.getAccessTokenManagerRef() == null) {
            policy.setAccessTokenManagerRef(new ResourceLink(DEFAULT_POLICY_ID));
        }
        HashSet<String> attributeNames = new HashSet<String>(policy.getAttributeContract().getExtendedAttributes().stream().map(Attribute::getName).collect(Collectors.toList()));
        this.initialize(policy.getId(), policy.getName(), policy.getAccessTokenManagerRef().getId(), String.valueOf(policy.getIdTokenLifetime()), policy.getIdTokenTypHeaderValue(), createMode, policy.getScopeAttributeMappings(), attributeNames);
    }

    public OpenIdConnectPolicyValidator(String id, String name, String tokenManagerId, String idTokenLifetime, String idTokenTypHeaderValue, boolean createMode) {
        this.initialize(id, name, tokenManagerId, idTokenLifetime, idTokenTypHeaderValue, createMode, null, null);
    }

    private void initialize(String id, String name, String tokenManagerId, String idTokenLifetime, String idTokenTypHeaderValue, boolean createMode, Map<String, ParameterValues> scopeAttributeMappings, Set<String> allAttributeNames) {
        this.id = id;
        this.name = name;
        this.accessTokenManagerId = tokenManagerId;
        this.idTokenLifetime = idTokenLifetime;
        this.idTokenTypHeaderValue = idTokenTypHeaderValue;
        this.createMode = createMode;
        this.allAttributeNames = allAttributeNames;
        this.scopeAttributeMappings = scopeAttributeMappings;
    }

    public boolean validate() {
        OpenIdConnectPolicyScopeAttributeValidator scopeAttributeValidator;
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager;
        if (StringUtils.isBlank((String)this.id)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_required, OpenIdConnectPolicyPaths.getId()));
        } else if (DEFAULT_POLICY_ID.equalsIgnoreCase(this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_default_invalid, OpenIdConnectPolicyPaths.getName(), new Object[]{this.name, "Name"}));
        } else if (DEFAULT_POLICY_ID.equalsIgnoreCase(this.id)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_default_invalid, OpenIdConnectPolicyPaths.getId(), new Object[]{this.id, "ID"}));
        } else if (this.isCreateMode() && (connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).getPolicy().containsPolicyGroup(this.id)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_in_use, OpenIdConnectPolicyPaths.getId()));
        }
        if (StringUtils.isBlank((String)this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_name_required, OpenIdConnectPolicyPaths.getName()));
        }
        if (!ValidationUtil.isValidInt((String)this.idTokenLifetime, (int)0, (int)65535)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_token_lifetime_invalid, OpenIdConnectPolicyPaths.getIdTokenLifetime(), new Object[]{0, 65535, 5}));
        }
        if (this.accessTokenManagerId == null || MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.accessTokenManagerId) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_token_manager_id_invalid, OpenIdConnectPolicyPaths.getAccessTokenManagerId()));
        }
        if (!StringUtils.isBlank((String)this.idTokenTypHeaderValue)) {
            if (this.idTokenTypHeaderValue.length() > 256) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_token_typ_header_value_length_invalid, OpenIdConnectPolicyPaths.getIdTokenTypHeaderValue(), new Object[]{256}));
            }
            if (this.idTokenTypHeaderValue.contains("\n") || this.idTokenTypHeaderValue.contains("\r")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_policy_id_token_typ_header_value_contains_new_line, OpenIdConnectPolicyPaths.getIdTokenTypHeaderValue()));
            }
        }
        if (this.scopeAttributeMappings != null && !(scopeAttributeValidator = new OpenIdConnectPolicyScopeAttributeValidator(this.scopeAttributeMappings, this.allAttributeNames)).validate()) {
            this.appendErrors(scopeAttributeValidator.getErrors());
        }
        return !this.hasErrors();
    }

    private boolean isCreateMode() {
        return this.createMode;
    }
}

