/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.OpenIdConnectMetadataPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.SourceType;

public class OpenIdRequestParamEntryValidator
extends AbstractValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private boolean isOverride = false;
    private String name;
    private String value;
    private int index = 0;
    private SourceType sourceType;

    public OpenIdRequestParamEntryValidator(String name, SourceType sourceType, String value, boolean isOverride) {
        this.name = name;
        this.sourceType = sourceType;
        this.value = value;
        this.isOverride = isOverride;
    }

    public OpenIdRequestParamEntryValidator(String name, String value, boolean isOverride, SourceType sourceType, int index) {
        this.name = name;
        this.value = value;
        this.isOverride = isOverride;
        this.index = index;
        this.sourceType = sourceType;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.name)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.openid_connect_no_param_name, OpenIdConnectMetadataPaths.getRequestParameters(this.index)));
        }
        if (this.sourceType == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.getSourceTypePath(OpenIdConnectMetadataPaths.getRequestParameters(this.index)), new Object[]{"Request parameter source type"}));
        } else if (SourceType.NO_MAPPING.equals((Object)this.sourceType)) {
            if (!this.isOverride) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_no_param_value_override_disabled, OpenIdConnectMetadataPaths.getRequestParameters(this.index), new Object[]{this.name}));
            }
        } else if (StringUtils.isEmpty((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_no_param_value_invalid_source_type, OpenIdConnectMetadataPaths.getRequestParameters(this.index), new Object[]{this.name}));
        }
        return !this.hasErrors();
    }
}

