/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.OIDCRequestParameter;
import com.pingidentity.admin.api.model.fieldpaths.OpenIdConnectMetadataPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OpenIdRequestParamsValidator
extends AbstractValidator {
    private final List<OIDCRequestParameter> reqParams;

    public OpenIdRequestParamsValidator(List<OIDCRequestParameter> apiReqParams) {
        this.reqParams = apiReqParams;
    }

    public boolean validate() {
        if (this.reqParams != null && !this.reqParams.isEmpty()) {
            for (int i = 0; i < this.reqParams.size(); ++i) {
                OIDCRequestParameter oidcReqParam = this.reqParams.get(i);
                if (!StringUtils.isNotEmpty((String)oidcReqParam.getName()) || !StringUtils.isNotEmpty((String)oidcReqParam.getValue()) || oidcReqParam.getAttributeValue() == null) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_param_value_selection_required, OpenIdConnectMetadataPaths.getRequestParameters(i), new Object[]{oidcReqParam.getName()}));
            }
        }
        return !this.hasErrors();
    }
}

