/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.UsernamePasswordCredentialsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.apache.commons.lang.StringUtils;

public class OutboundBackChannelBasicAuthValidator
extends UsernamePasswordCredentialsValidator {
    protected final String username;

    public OutboundBackChannelBasicAuthValidator(UsernamePasswordCredentials creds) {
        super(creds.getUsername(), creds.getPassword(), creds.getEncryptedPassword(), ConnectionPaths.getOutboundBackChannelAuthBasicUsername(), ConnectionPaths.getOutboundBackChannelAuthBasicPassword(), ConnectionPaths.getOutboundBackChannelAuthBasicEncryptedPassword());
        this.username = creds.getUsername();
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors() && !StringUtils.isBlank((String)this.username) && this.username.contains(":")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.basicauth_no_colon, ConnectionPaths.getOutboundBackChannelAuthBasicUsername()));
        }
        return !this.hasErrors();
    }
}

