/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.OutboundBackChannelAuth;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractBackChannelValidator;
import com.pingidentity.admin.api.validator.OutboundBackChannelAuthTypeValidator;
import com.pingidentity.admin.api.validator.OutboundBackChannelBasicAuthValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class OutboundBackChannelValidator
extends AbstractBackChannelValidator {
    public OutboundBackChannelValidator(Connection connection) {
        this.connection = connection;
        if (this.isBackChannelAuthenticationNeeded() && this.isInboundArtifactSelected()) {
            if (connection.getCredentials().getOutboundBackChannelAuth() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getOutboundBackChannelAuth(), new Object[]{ConnectionPaths.getOutboundBackChannelAuth()}));
            }
        } else if (connection.getCredentials().getOutboundBackChannelAuth() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getOutboundBackChannelAuth(), new Object[]{ConnectionPaths.getOutboundBackChannelAuth()}));
        }
    }

    public boolean validate() {
        if (this.hasErrors()) {
            return false;
        }
        if (!this.isBackChannelAuthenticationNeeded() || !this.isInboundArtifactSelected()) {
            return true;
        }
        OutboundBackChannelAuthTypeValidator authValidator = new OutboundBackChannelAuthTypeValidator(this.connection);
        authValidator.validate();
        this.appendErrors(authValidator.getErrors());
        if (this.hasErrors()) {
            return false;
        }
        OutboundBackChannelAuth obAuth = this.connection.getCredentials().getOutboundBackChannelAuth();
        if (obAuth.getHttpBasicCredentials() != null) {
            OutboundBackChannelBasicAuthValidator basicValidator = new OutboundBackChannelBasicAuthValidator(obAuth.getHttpBasicCredentials());
            basicValidator.validate();
            this.appendErrors(basicValidator.getErrors());
        }
        if (obAuth.getSslAuthKeyPairRef() != null) {
            ResourceLink certLink = this.connection.getCredentials().getOutboundBackChannelAuth().getSslAuthKeyPairRef();
            if (certLink == null || certLink.getId() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.outbound_backchannel_sslauth_key_pair_required, ConnectionPaths.getOutboundBackChannelAuthCertId()));
                return false;
            }
            String alias = certLink.getId();
            PkCert pkCert = MgmtFactory.getSslAuthPkCertManager().getPkCert(alias);
            if (pkCert == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.outbound_backchannel_sslauth_key_pair_not_found, ConnectionPaths.getOutboundBackChannelAuthCertId(), new Object[]{alias}));
            }
        }
        return !this.hasErrors();
    }

    private boolean isInboundArtifactSelected() {
        if (this.connection.getType().getRole() == Role.SP && this.connection.getBrowserSso() != null && Protocol.isSaml1x(this.connection.getBrowserSso().getProtocol())) {
            return false;
        }
        boolean selected = false;
        selected = this.isInboundArtifact();
        selected |= this.isSoapSlo();
        if (Role.IDP == this.connection.getType().getRole()) {
            selected |= ((IdpConnection)this.connection).getAttributeQuery() != null;
        }
        return selected;
    }
}

