/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Channel;
import com.pingidentity.admin.api.model.OutboundProvision;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ChannelValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.InboundProvisioningCustomScimAttributeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SaasTargetValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OutboundProvisionValidator
extends CompositeValidator {
    private OutboundProvision outboundProvisioning;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private static final SaasPluginManager saasManager = SaasPluginManager.getInstance();
    private SaasProvisionerPlugin pluginInstance;
    private String type;
    private final ConnectionBase existingConn;

    OutboundProvisionValidator(OutboundProvision outboundProvisioning, ConnectionBase existingConn, ValidatorContext context) {
        this.outboundProvisioning = outboundProvisioning;
        this.existingConn = existingConn;
        if (outboundProvisioning != null) {
            this.type = outboundProvisioning.getType();
            this.addValidator((Validator)new NotBlankValidator(this.type, ConnectionPaths.OutboundProvisionPaths.getType(), ConnectionPaths.OutboundProvisionPaths.getType()));
            if (this.type != null) {
                this.pluginInstance = saasManager.getPluginInstance(this.type);
                SaasTargetValidator targetValidator = new SaasTargetValidator(this.pluginInstance, outboundProvisioning.getTargetSettings(), context);
                this.addValidator((Validator)targetValidator);
                if (outboundProvisioning.getChannels() != null) {
                    this.validateChannels(context);
                }
            }
        }
    }

    @Override
    public boolean validate() {
        ValidationError error;
        if (this.outboundProvisioning == null) {
            return true;
        }
        if (!MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableOutboundProvisioning()) {
            ValidationError error2 = this.errorFactory.create(ApiMessageKey.outbound_provisioning_not_enabled, ConnectionPaths.getOutboundProvision());
            this.appendError(error2);
            return false;
        }
        if (this.pluginInstance == null) {
            Set validConnectorsId = saasManager.getPluginIds().keySet();
            String validConnectorIds = String.join((CharSequence)",", validConnectorsId);
            ValidationError error3 = this.errorFactory.create(ApiMessageKey.outbound_provisioning_invalid_type, ConnectionPaths.OutboundProvisionPaths.getType(), new Object[]{this.type, validConnectorIds});
            this.appendError(error3);
            return false;
        }
        if (this.outboundProvisioning.getCustomSchema() != null) {
            if (this.outboundProvisioning.getCustomSchema().getAttributes() == null) {
                error = this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.OutboundProvisionPaths.getCustomSchemaAttribute(), new Object[]{ConnectionPaths.OutboundProvisionPaths.getCustomSchemaAttribute()});
                this.appendError(error);
            } else {
                HashSet<String> names = new HashSet<String>();
                int index = 0;
                for (SchemaAttribute attribute : this.outboundProvisioning.getCustomSchema().getAttributes()) {
                    if (names.contains(attribute.getName())) {
                        ValidationError error4 = this.errorFactory.create(ApiMessageKey.provisioning_custom_attr_name_exists, ConnectionPaths.OutboundProvisionPaths.getCustomSchema(), new Object[]{attribute.getName()});
                        this.appendError(error4);
                    } else {
                        InboundProvisioningCustomScimAttributeValidator validator = new InboundProvisioningCustomScimAttributeValidator(this.outboundProvisioning.getCustomSchema().getNamespace(), attribute, new ArrayList<String>(), ConnectionPaths.OutboundProvisionPaths.getCustomSchemaAttribute(index));
                        validator.validate();
                        this.appendErrors(validator.getErrors());
                        names.add(attribute.getName());
                    }
                    ++index;
                }
            }
        }
        if (this.outboundProvisioning.getChannels() == null || this.outboundProvisioning.getChannels().isEmpty()) {
            error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_no_channels, ConnectionPaths.OutboundProvisionPaths.getChannels());
            this.appendError(error);
            return false;
        }
        if (!this.hasErrors()) {
            return super.validate();
        }
        return !this.hasErrors();
    }

    private void validateChannels(ValidatorContext context) {
        HashSet<String> channelNames = new HashSet<String>();
        int index = 0;
        for (Channel channel : this.outboundProvisioning.getChannels()) {
            String name = channel.getName();
            this.addDuplicateErrors(channelNames, name, ApiMessageKey.outbound_provisioning_duplicate_channel_name, ConnectionPaths.OutboundProvisionPaths.getChannelName(index));
            ChannelValidator channelValidator = new ChannelValidator(this.pluginInstance, index, channel, this.outboundProvisioning.getCustomSchema(), this.getExistingChannel(name), context);
            this.addValidator((Validator)channelValidator);
            channelNames.add(name);
            ++index;
        }
    }

    private com.pingidentity.provisioner.domain.Channel getExistingChannel(String name) {
        ProvisionerConfig provisionerConfig;
        if (this.existingConn != null && (provisionerConfig = (ProvisionerConfig)this.existingConn.getModuleConfiguration(ProvisionerConfig.class)) != null) {
            for (com.pingidentity.provisioner.domain.Channel channel : provisionerConfig.getChannels()) {
                if (!channel.getName().equals(name)) continue;
                return channel;
            }
        }
        return null;
    }

    private void addDuplicateErrors(Set<String> entries, String newEntry, ApiMessageKey errorKey, String path) {
        if (newEntry != null && entries.contains(newEntry)) {
            ValidationError error = this.errorFactory.create(errorKey, path, new Object[]{newEntry});
            this.appendError(error);
        }
    }
}

