/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.PasswordCredentialValidator;
import com.pingidentity.admin.api.model.plugin.PasswordCredentialValidatorAttribute;
import com.pingidentity.admin.api.model.plugin.PasswordCredentialValidatorAttributeContract;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PcvValidator
extends PluginInstanceValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final PasswordCredentialValidator pcv;

    public PcvValidator(PasswordCredentialValidator apiInstance, boolean isCreate, ValidatorContext validatorContext) {
        super(apiInstance, PluginEnum.PASSWORD_CREDENTIAL_VALIDATOR.getPluginManager(), isCreate, PluginEnum.PASSWORD_CREDENTIAL_VALIDATOR, validatorContext);
        this.pcv = apiInstance;
    }

    @Override
    public boolean validate() {
        boolean doContractValidation;
        super.validate();
        boolean askedForParent = this.pcv.getParentRef() != null;
        PasswordCredentialValidatorAttributeContract attributeContract = this.pcv.getAttributeContract();
        boolean isInherited = this.getBooleanVal(attributeContract.isInherited());
        boolean bl = doContractValidation = !isInherited || !askedForParent;
        if (isInherited && !askedForParent) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_attribute_contract_parent_not_defined, PluginInstancePaths.AttributeContractPaths.getContractInherited()));
        }
        if (doContractValidation) {
            boolean pluginAllowsExtAttrs = true;
            LinkedList<PasswordCredentialValidatorAttribute> attributes = new LinkedList<PasswordCredentialValidatorAttribute>();
            String pluginTypeId = null;
            if (this.pcv.getPluginDescriptorRef() != null) {
                pluginTypeId = this.pcv.getPluginDescriptorRef().getId();
            }
            if (pluginTypeId != null) {
                for (PluginDescriptor pluginDescriptor : PluginEnum.PASSWORD_CREDENTIAL_VALIDATOR.getPluginManager().getInstalledDescriptors()) {
                    if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
                    Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
                    if (descriptorAttrs != null) {
                        for (String coreAttrName : descriptorAttrs) {
                            PasswordCredentialValidatorAttribute adapterAttr = new PasswordCredentialValidatorAttribute();
                            adapterAttr.setName(coreAttrName);
                            attributes.add(adapterAttr);
                        }
                    }
                    pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
                    break;
                }
            }
            List<Object> extendedAttrs = new LinkedList();
            if (!pluginAllowsExtAttrs && attributeContract.getExtendedAttributes() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes()));
            } else {
                extendedAttrs = attributeContract.getExtendedAttributes();
            }
            AttributeContractValidator attributeContractValidator = new AttributeContractValidator(attributes, extendedAttrs, PluginInstancePaths.AttributeContractPaths.getAttributeContract());
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
        }
        return !this.hasErrors();
    }
}

