/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.PersistentGrantSourceTypeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PersistentGrantSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final Set<String> validAttributeNames;
    private final String prefix;

    public PersistentGrantSourceTypeValidatorBuilder(String authnContextId) {
        this.validAttributeNames = this.getPersistentGrantAttrNames(authnContextId);
        this.prefix = null;
    }

    public PersistentGrantSourceTypeValidatorBuilder(String authnContextId, String prefix) {
        this.validAttributeNames = this.getPersistentGrantAttrNames(authnContextId);
        this.prefix = prefix;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), SourceType.OAUTH_PERSISTENT_GRANT);
        return new PersistentGrantSourceTypeValidator(attributeName, afv.getValue(), this.validAttributeNames, attributePath, PersistentGrantSourceTypeValidator.PersistentGrantSourceTypeMsgContext.ATTR_MAPPING);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), SourceType.OAUTH_PERSISTENT_GRANT);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new PersistentGrantSourceTypeValidator(null, icEntry.getAttributeName(), this.validAttributeNames, attributePath, PersistentGrantSourceTypeValidator.PersistentGrantSourceTypeMsgContext.ISSUANCE_CRITERIA), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return StringUtils.isBlank((String)this.prefix) ? this.validAttributeNames : this.validAttributeNames.stream().map(s -> this.prefix + s).collect(Collectors.toSet());
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    private Set<String> getPersistentGrantAttrNames(String authnContextId) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        if ("client_credentials".equals(authnContextId)) {
            return authzServerManager.getClientCredentialsContract().getAllAttributeNames();
        }
        Set attributes = authzServerManager.getKeyOnlyContract().getAllAttributeNames();
        attributes.add("EXPIRES_AT");
        return attributes;
    }
}

