/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PluginConfigConsistencyValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginConfigConsistencyValidator.class);
    private List<ConfigurationValidator> validators;
    private Configuration config;
    private String configPath;
    private ValidatorContext validatorContext;

    public PluginConfigConsistencyValidator(List<ConfigurationValidator> validators, Configuration config, String configPath) {
        this.validators = validators;
        this.config = config;
        this.configPath = configPath;
    }

    public PluginConfigConsistencyValidator(List<ConfigurationValidator> validators, Configuration config, String configPath, ValidatorContext validatorContext) {
        this(validators, config, configPath);
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        for (ConfigurationValidator configValidator : this.validators) {
            try {
                configValidator.validate(this.config);
            }
            catch (ValidationException e) {
                for (String errorMsg : e.getErrorMessages()) {
                    this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, this.configPath));
                }
                break;
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Unexpected exception thrown from plugin configuration validator");
                if (e.getMessage() != null) {
                    msg.append(": ");
                    msg.append(e.getMessage());
                } else {
                    msg.append(".");
                }
                this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), msg.toString(), this.configPath));
                log.error((Object)msg, (Throwable)e);
            }
        }
        return !this.hasErrors();
    }
}

