/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PluginFieldValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginFieldValidator.class);
    private FieldDescriptor fieldDescriptor;
    private Field field;
    private String fieldPath;
    private ValidatorContext validatorContext;

    public PluginFieldValidator(FieldDescriptor descriptor, Field field, String fieldPath, ValidatorContext validatorContext) {
        this.fieldDescriptor = descriptor;
        this.field = field;
        this.fieldPath = fieldPath;
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        List fieldValidators = this.fieldDescriptor.getValidationChain();
        if (fieldValidators != null) {
            for (FieldDescriptor.FieldValidationWrapper validationWrapper : fieldValidators) {
                FieldValidator validator;
                if (validationWrapper.isSkipIfValueIsEmpty() && StringUtils.isBlank((String)this.field.getValue()) || this.bypassValidation(validator = validationWrapper.getValidator())) continue;
                try {
                    validator.validate(this.field);
                }
                catch (ValidationException e) {
                    for (String errorMsg : e.getErrorMessages()) {
                        this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, this.fieldPath));
                    }
                    break;
                }
                catch (Exception e) {
                    String msg = "Unexpected exception thrown from " + validator;
                    this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), msg, this.fieldPath));
                    log.warn((Object)(msg + ": " + e));
                }
            }
        }
        return !this.hasErrors();
    }

    private boolean bypassValidation(FieldValidator validator) {
        return this.validatorContext != null && this.validatorContext.isBypassExternalValidation() && validator.isExternalValidator();
    }
}

